/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.wrap.param;

import java.io.Serializable;
import xyz.noark.core.ioc.wrap.ParamWrapper;
import xyz.noark.core.network.NetworkPacket;
import xyz.noark.core.network.PacketCodecHolder;
import xyz.noark.core.network.Session;
import xyz.noark.core.util.StringUtils;

public class PacketParamWrapper
implements ParamWrapper {
    private final Class<?> klass;

    public PacketParamWrapper(Class<?> klass) {
        this.klass = klass;
    }

    @Override
    public Object read(Session session, NetworkPacket packet) {
        return PacketCodecHolder.getPacketCodec().decodeProtocol(packet.getByteArray(), this.klass);
    }

    @Override
    public String toString(Session session, NetworkPacket packet) {
        Object object = this.read(session, packet);
        if (object == null) {
            return "protocol=null";
        }
        String protocol = object.toString();
        if (StringUtils.isNotEmpty(protocol)) {
            protocol = protocol.replace('\n', ',');
            protocol = protocol.substring(0, protocol.length() - 1);
        }
        return StringUtils.join("protocol={", protocol, "}");
    }

    @Override
    public Object read(Serializable playerId, Object protocol) {
        return protocol;
    }
}

