/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import xyz.noark.core.lang.AbstractPair;

public final class ImmutablePair<L, R>
extends AbstractPair<L, R> {
    private static final long serialVersionUID = -4331739966766356742L;
    private static final ImmutablePair NULL = ImmutablePair.of(null, null);
    private final L left;
    private final R right;

    public ImmutablePair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public static <L, R> ImmutablePair<L, R> nullPair() {
        return NULL;
    }

    public static <L, R> ImmutablePair<L, R> of(L left, R right) {
        return new ImmutablePair<L, R>(left, right);
    }

    public static <L, R> ImmutablePair<L, R> ofLeft(L left) {
        return new ImmutablePair<L, Object>(left, null);
    }

    public static <L, R> ImmutablePair<L, R> ofRight(R right) {
        return new ImmutablePair<Object, R>(null, right);
    }

    @Override
    public L getLeft() {
        return this.left;
    }

    @Override
    public R getRight() {
        return this.right;
    }

    @Override
    public R setValue(R value) {
        throw new UnsupportedOperationException();
    }
}

