/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.lang.Pair;
import xyz.noark.core.lang.PairMap;
import xyz.noark.core.util.MapUtils;

public class PairHashMap<L, R, V>
implements PairMap<L, R, V> {
    private final HashMap<Pair<L, R>, V> hashmap;

    public PairHashMap() {
        this.hashmap = new HashMap();
    }

    public PairHashMap(int size) {
        this.hashmap = MapUtils.newHashMap(size);
    }

    public PairHashMap(List<V> templates, Function<? super V, ? extends L> leftMapper, Function<? super V, ? extends R> rightMapper) {
        this(templates.size());
        for (V template : templates) {
            Function<V, R> object = super.put((L)template, (R)leftMapper, (V)rightMapper);
            if (object == null) continue;
            String name = object.getClass().getName();
            L left = leftMapper.apply(object);
            R right = rightMapper.apply(object);
            throw new ServerBootstrapException("\u91cd\u590d\u4e3b\u952e class=" + name + ", left=" + left + ", right=" + right);
        }
    }

    @Override
    private V put(V value, Function<? super V, ? extends L> leftMapper, Function<? super V, ? extends R> rightMapper) {
        return this.put(leftMapper.apply(value), rightMapper.apply(value), value);
    }

    @Override
    public V put(L left, R right, V value) {
        return this.hashmap.put(Pair.of(left, right), value);
    }

    @Override
    public V remove(L left, R right) {
        return this.hashmap.remove(Pair.of(left, right));
    }

    @Override
    public int size() {
        return this.hashmap.size();
    }

    @Override
    public V get(L left, R right) {
        return this.hashmap.get(Pair.of(left, right));
    }

    @Override
    public V getOrDefault(L left, R right, V defaultValue) {
        return this.hashmap.getOrDefault(Pair.of(left, right), defaultValue);
    }

    @Override
    public Collection<V> values() {
        return this.hashmap.values();
    }

    public String toString() {
        return "PairHashMap [data=" + this.hashmap + "]";
    }
}

