/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import xyz.noark.core.util.StringUtils;

public class ResourceLoader {
    protected static final String CLASSPATH_URL_PREFIX = "classpath:";

    protected InputStream newInputStream(String path, String zone, String fileName) throws IOException {
        if (path.startsWith(CLASSPATH_URL_PREFIX)) {
            return this.newClasspathInputStream(path, zone, fileName);
        }
        return Files.newInputStream(Paths.get(path, zone, fileName), StandardOpenOption.READ);
    }

    private InputStream newClasspathInputStream(String path, String zone, String fileName) {
        StringBuilder sb = new StringBuilder(path.length() + fileName.length());
        sb.append(path, CLASSPATH_URL_PREFIX.length(), path.length());
        this.buildSeparatorChar(sb);
        if (StringUtils.isNotEmpty(zone)) {
            sb.append(zone);
            this.buildSeparatorChar(sb);
        }
        sb.append(fileName);
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(sb.toString());
    }

    private void buildSeparatorChar(StringBuilder sb) {
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) != File.separatorChar) {
            sb.append(File.separatorChar);
        }
    }

    protected BufferedReader newBufferedReader(String path, String zone, String fileName, Charset charset) throws IOException {
        InputStream is = this.newInputStream(path, zone, fileName);
        return new BufferedReader(new InputStreamReader(is, charset.newDecoder()));
    }
}

