/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class TimeoutHashMap<K, V> {
    private final LoadingCache<K, V> caches;

    public TimeoutHashMap(long duration, TimeUnit unit, Supplier<? extends V> loading) {
        this.caches = Caffeine.newBuilder().expireAfterAccess(duration, unit).build(key -> loading.get());
    }

    public TimeoutHashMap(long duration, TimeUnit unit, int maximumSize, Supplier<? extends V> loading) {
        this.caches = Caffeine.newBuilder().expireAfterAccess(duration, unit).maximumSize((long)maximumSize).build(key -> loading.get());
    }

    public TimeoutHashMap(long duration, TimeUnit unit, CacheLoader<? super K, V> loader) {
        this.caches = Caffeine.newBuilder().expireAfterAccess(duration, unit).build(key -> loader.load(key));
    }

    public TimeoutHashMap(long duration, TimeUnit unit, int maximumSize, CacheLoader<? super K, V> loader) {
        this.caches = Caffeine.newBuilder().expireAfterAccess(duration, unit).maximumSize((long)maximumSize).build(key -> loader.load(key));
    }

    public V get(K key) {
        return (V)this.caches.get(key);
    }
}

