/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.lang.Triple;
import xyz.noark.core.lang.TripleMap;
import xyz.noark.core.util.MapUtils;

public class TripleHashMap<L, M, R, V>
implements TripleMap<L, M, R, V> {
    private final HashMap<Triple<L, M, R>, V> hashmap;

    public TripleHashMap() {
        this.hashmap = new HashMap();
    }

    public TripleHashMap(int size) {
        this.hashmap = MapUtils.newHashMap(size);
    }

    public TripleHashMap(List<V> templates, Function<? super V, ? extends L> leftMapper, Function<? super V, ? extends M> middleMapper, Function<? super V, ? extends R> rightMapper) {
        this(templates.size());
        for (V template : templates) {
            Function<V, R> object = super.put((L)template, (M)leftMapper, (R)middleMapper, (V)rightMapper);
            if (object == null) continue;
            String name = object.getClass().getName();
            L left = leftMapper.apply(object);
            M middle = middleMapper.apply(object);
            R right = rightMapper.apply(object);
            throw new ServerBootstrapException("\u91cd\u590d\u4e3b\u952e class=" + name + ", left=" + left + ", middle=" + middle + ", right=" + right);
        }
    }

    @Override
    private V put(V value, Function<? super V, ? extends L> leftMapper, Function<? super V, ? extends M> middleMapper, Function<? super V, ? extends R> rightMapper) {
        return this.put(leftMapper.apply(value), middleMapper.apply(value), rightMapper.apply(value), value);
    }

    @Override
    public int size() {
        return this.hashmap.size();
    }

    @Override
    public V put(L left, M middle, R right, V value) {
        return this.hashmap.put(Triple.of(left, middle, right), value);
    }

    @Override
    public V remove(L left, M middle, R right) {
        return this.hashmap.remove(Triple.of(left, middle, right));
    }

    @Override
    public V get(L left, M middle, R right) {
        return this.hashmap.get(Triple.of(left, middle, right));
    }

    @Override
    public V getOrDefault(L left, M middle, R right, V defaultValue) {
        return this.hashmap.getOrDefault(Triple.of(left, middle, right), defaultValue);
    }

    @Override
    public Collection<V> values() {
        return this.hashmap.values();
    }

    public String toString() {
        return "TripleHashMap [hashmap=" + this.hashmap + "]";
    }
}

