/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.thread;

import java.io.Serializable;
import xyz.noark.core.exception.ExceptionHelper;
import xyz.noark.core.thread.AsyncHelper;
import xyz.noark.core.thread.TaskContext;
import xyz.noark.core.util.DateUtils;
import xyz.noark.log.LogHelper;

public abstract class AbstractAsyncTask
implements Runnable {
    protected final long createTime = System.nanoTime();
    protected long startExecuteTime;
    private final Serializable queueId;
    protected final Serializable playerId;

    public AbstractAsyncTask(Serializable queueId, Serializable playerId) {
        this.queueId = queueId;
        this.playerId = playerId;
    }

    @Override
    public void run() {
        this.startExecuteTime = System.nanoTime();
        this.execCommandBefore();
        try {
            this.doSomething();
        }
        catch (Throwable e) {
            this.execCommandException(e);
        }
        finally {
            this.execCommandAfter(this.startExecuteTime);
        }
    }

    protected void execCommandBefore() {
        AsyncHelper.setTaskContext(new TaskContext(this.queueId, this.playerId));
    }

    protected abstract void doSomething();

    protected void execCommandException(Throwable e) {
        if (this.playerId == null) {
            LogHelper.logger.error("handle {} exception.{}", new Object[]{this.logCode(), e});
        } else {
            LogHelper.logger.error("handle {} exception. playerId={}{}", new Object[]{this.logCode(), this.playerId, e});
        }
        ExceptionHelper.monitor(e);
    }

    protected void execCommandAfter(long startExecuteTime) {
        AsyncHelper.removeTaskContext();
        if (this.isPrintLog()) {
            float delay = DateUtils.formatNanoTime(startExecuteTime - this.createTime);
            float exec = DateUtils.formatNanoTime(System.nanoTime() - startExecuteTime);
            if (this.playerId == null) {
                LogHelper.logger.info("handle {},delay={} ms,exec={} ms", new Object[]{this.logCode(), Float.valueOf(delay), Float.valueOf(exec)});
            } else {
                LogHelper.logger.info("handle {},delay={} ms,exec={} ms playerId={}", new Object[]{this.logCode(), Float.valueOf(delay), Float.valueOf(exec), this.playerId});
            }
        }
    }

    protected abstract String logCode();

    protected abstract boolean isPrintLog();
}

