/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.thread;

import java.io.Serializable;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.StaticComponent;
import xyz.noark.core.thread.TaskCallback;
import xyz.noark.core.thread.TaskContext;
import xyz.noark.core.thread.ThreadDispatcher;

@StaticComponent
public class AsyncHelper {
    private static final ThreadLocal<TaskContext> THREAD_LOCAL = new ThreadLocal();
    @Autowired
    private static ThreadDispatcher threadDispatcher;

    private AsyncHelper() {
    }

    static void setTaskContext(TaskContext taskContext) {
        THREAD_LOCAL.set(taskContext);
    }

    static void removeTaskContext() {
        THREAD_LOCAL.remove();
    }

    public static void localCall(TaskCallback callback) {
        TaskContext context = THREAD_LOCAL.get();
        AsyncHelper.call(context.getQueueId(), callback, context.getPlayerId());
    }

    public static void call(Serializable queueId, TaskCallback callback) {
        TaskContext context = THREAD_LOCAL.get();
        AsyncHelper.call(queueId, callback, context.getPlayerId());
    }

    public static void randomCall(TaskCallback callback) {
        TaskContext context = THREAD_LOCAL.get();
        AsyncHelper.call(null, callback, context.getPlayerId());
    }

    private static void call(Serializable queueId, TaskCallback callback, Serializable playerId) {
        threadDispatcher.dispatch(queueId, callback, playerId, true);
    }
}

