/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.thread;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import xyz.noark.core.thread.AsyncQueueTask;

public class TaskQueue {
    private final Serializable id;
    private final ExecutorService threadPool;
    private LinkedList<AsyncQueueTask> queue;

    public TaskQueue(Serializable id, ExecutorService threadPool) {
        this.id = id;
        this.threadPool = threadPool;
        this.queue = new LinkedList();
    }

    public Serializable getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(AsyncQueueTask task) {
        TaskQueue taskQueue = this;
        synchronized (taskQueue) {
            this.queue.add(task);
            if (this.queue.size() == 1) {
                this.exec(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        TaskQueue taskQueue = this;
        synchronized (taskQueue) {
            this.queue.removeFirst();
            if (!this.queue.isEmpty()) {
                this.exec(this.queue.getFirst());
            }
        }
    }

    protected ExecutorService getThreadPool() {
        return this.threadPool;
    }

    protected void exec(AsyncQueueTask task) {
        this.threadPool.execute(task);
    }
}

