/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.thread;

import com.github.benmanes.caffeine.cache.CacheLoader;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.Service;
import xyz.noark.core.event.Event;
import xyz.noark.core.event.FixedTimeEvent;
import xyz.noark.core.event.PlayerEvent;
import xyz.noark.core.event.QueueEvent;
import xyz.noark.core.exception.UnrealizedException;
import xyz.noark.core.ioc.manager.PacketMethodManager;
import xyz.noark.core.ioc.wrap.method.EventMethodWrapper;
import xyz.noark.core.ioc.wrap.method.PacketMethodWrapper;
import xyz.noark.core.ioc.wrap.method.ScheduledMethodWrapper;
import xyz.noark.core.lang.TimeoutHashMap;
import xyz.noark.core.network.NetworkListener;
import xyz.noark.core.network.NetworkPacket;
import xyz.noark.core.network.ResultHelper;
import xyz.noark.core.network.Session;
import xyz.noark.core.network.SessionAttrKey;
import xyz.noark.core.network.SessionManager;
import xyz.noark.core.thread.AsyncQueueTask;
import xyz.noark.core.thread.AsyncTask;
import xyz.noark.core.thread.AsyncThreadCommand;
import xyz.noark.core.thread.MonitorTaskQueue;
import xyz.noark.core.thread.MonitorThreadPool;
import xyz.noark.core.thread.NamedThreadFactory;
import xyz.noark.core.thread.TaskCallback;
import xyz.noark.core.thread.TaskQueue;
import xyz.noark.core.thread.command.PlayerThreadCommand;
import xyz.noark.core.thread.command.QueueThreadCommand;
import xyz.noark.core.thread.command.SystemThreadCommand;
import xyz.noark.log.LogHelper;

@Service
public class ThreadDispatcher {
    private static final int SHUTDOWN_MAX_TIME = 10;
    private ExecutorService businessThreadPool;
    private TimeoutHashMap<Serializable, TaskQueue> businessThreadPoolTaskQueue;
    @Autowired(required=false)
    private NetworkListener networkListener;
    @Autowired(required=false)
    private MonitorThreadPool monitorThreadPool;

    public void init(int poolSize, String threadNamePrefix, int timeout, int execTimeout, boolean outputStack) {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        NamedThreadFactory threadFactory = new NamedThreadFactory(threadNamePrefix);
        this.businessThreadPool = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, workQueue, threadFactory);
        this.businessThreadPoolTaskQueue = new TimeoutHashMap<Serializable, TaskQueue>((long)timeout, TimeUnit.MINUTES, this.buildLoader(execTimeout, outputStack));
    }

    private CacheLoader<Serializable, TaskQueue> buildLoader(int execTimeout, boolean outputStack) {
        if (execTimeout > 0) {
            return id -> new MonitorTaskQueue((Serializable)id, this.monitorThreadPool, this.businessThreadPool, execTimeout, outputStack);
        }
        return id -> new TaskQueue((Serializable)id, this.businessThreadPool);
    }

    public void dispatchPacket(Session session, NetworkPacket packet) {
        PacketMethodWrapper pmw = PacketMethodManager.getInstance().getPacketMethodWrapper(packet.getOpcode());
        if (pmw == null) {
            LogHelper.logger.warn("undefined protocol, opcode={}", new Object[]{packet.getOpcode()});
            return;
        }
        if (pmw.isDeprecated()) {
            LogHelper.logger.warn("deprecated protocol. opcode={}, playerId={}", new Object[]{packet.getOpcode(), session.getPlayerId()});
            if (this.networkListener != null) {
                this.networkListener.handleDeprecatedPacket(session, packet);
            }
            return;
        }
        if (pmw.isInner()) {
            LogHelper.logger.warn(" ^0^ inner protocol. opcode={}, playerId={}", new Object[]{packet.getOpcode(), session.getPlayerId()});
            return;
        }
        if (!pmw.isAllState() && !pmw.getStateSet().contains((Object)session.getState())) {
            LogHelper.logger.warn(" ^0^ session state error. opcode={}, playerId={}", new Object[]{packet.getOpcode(), session.getPlayerId()});
            return;
        }
        pmw.incrCallNum();
        this.dispatchPacket(session, session.getPlayerId(), packet, pmw, pmw.analysisParam(session, packet));
    }

    public void dispatchInnerPacket(Serializable playerId, Serializable opcode, Object protocol) {
        PacketMethodWrapper pmw = PacketMethodManager.getInstance().getPacketMethodWrapper(opcode);
        if (pmw == null) {
            LogHelper.logger.warn("undefined protocol, opcode={}", new Object[]{opcode});
            return;
        }
        if (pmw.isDeprecated()) {
            LogHelper.logger.warn("deprecated protocol. opcode={}, playerId={}", new Object[]{opcode, playerId});
            return;
        }
        pmw.incrCallNum();
        this.dispatchPacket(null, playerId, null, pmw, pmw.analysisParam(playerId, protocol));
    }

    private void dispatchPacket(Session session, Serializable playerId, NetworkPacket packet, PacketMethodWrapper pmw, Object ... args) {
        switch (pmw.threadGroup()) {
            case NettyThreadGroup: {
                this.dispatchNettyThreadHandle(session, packet, pmw, args);
                break;
            }
            case PlayerThreadGroup: {
                this.dispatchPlayerThreadHandle(session, packet, new PlayerThreadCommand(playerId, pmw, args));
                break;
            }
            case ModuleThreadGroup: {
                this.dispatchSystemThreadHandle(session, packet, new SystemThreadCommand(playerId, pmw.getModule(), pmw, args));
                break;
            }
            case QueueThreadGroup: {
                Object id = session.attr(SessionAttrKey.valueOf(pmw.getQueueIdKey())).get();
                if (!Objects.nonNull(id) || !(id instanceof Serializable)) break;
                this.dispatchHandle(session, packet, (Serializable)id, new QueueThreadCommand(playerId, pmw, args));
                break;
            }
            default: {
                throw new UnrealizedException("\u975e\u6cd5\u7ebf\u7a0b\u6267\u884c\u7ec4:" + (Object)((Object)pmw.threadGroup()));
            }
        }
    }

    void dispatchNettyThreadHandle(Session session, NetworkPacket packet, PacketMethodWrapper protocol, Object ... args) {
        ResultHelper.trySendResult(session, packet, protocol.invoke(args));
    }

    void dispatchSystemThreadHandle(Session session, NetworkPacket packet, SystemThreadCommand command) {
        TaskQueue taskQueue = this.businessThreadPoolTaskQueue.get((Serializable)((Object)command.getModule()));
        taskQueue.submit(new AsyncQueueTask(taskQueue, command, command.getPlayerId(), packet, session));
    }

    void dispatchPlayerThreadHandle(Session session, NetworkPacket packet, PlayerThreadCommand command) {
        TaskQueue taskQueue = this.businessThreadPoolTaskQueue.get(command.getPlayerId());
        taskQueue.submit(new AsyncQueueTask(taskQueue, command, command.getPlayerId(), packet, session));
    }

    private void dispatchHandle(Session session, NetworkPacket packet, Serializable id, QueueThreadCommand command) {
        TaskQueue taskQueue = this.businessThreadPoolTaskQueue.get(id);
        taskQueue.submit(new AsyncQueueTask(taskQueue, command, command.getPlayerId(), packet, session));
    }

    public void dispatch(Serializable queueId, TaskCallback callback, Serializable playerId, boolean printLog) {
        if (queueId == null) {
            this.businessThreadPool.execute(new AsyncTask(callback, playerId, printLog));
        } else {
            TaskQueue taskQueue = this.businessThreadPoolTaskQueue.get(queueId);
            taskQueue.submit(new AsyncQueueTask(taskQueue, new AsyncThreadCommand(callback), playerId));
        }
    }

    public void dispatchEvent(EventMethodWrapper handler, Event event) {
        switch (handler.threadGroup()) {
            case PlayerThreadGroup: {
                if (event instanceof PlayerEvent) {
                    PlayerEvent e = (PlayerEvent)event;
                    this.dispatchPlayerThreadHandle(null, null, new PlayerThreadCommand(e.getPlayerId(), handler, e));
                    break;
                }
                throw new UnrealizedException("\u73a9\u5bb6\u7ebf\u7a0b\u76d1\u542c\u7684\u4e8b\u4ef6\uff0c\u9700\u8981\u5b9e\u73b0PlayerEvent\u63a5\u53e3. event=" + event.getClass().getSimpleName());
            }
            case ModuleThreadGroup: {
                this.dispatchSystemThreadHandle(null, null, new SystemThreadCommand(handler.getModule(), handler, event));
                break;
            }
            case QueueThreadGroup: {
                if (event instanceof QueueEvent) {
                    QueueEvent e = (QueueEvent)event;
                    this.dispatchHandle(null, null, ((QueueEvent)event).getQueueId(), new QueueThreadCommand(null, handler, e));
                    break;
                }
                throw new UnrealizedException("\u73a9\u5bb6\u7ebf\u7a0b\u76d1\u542c\u7684\u4e8b\u4ef6\uff0c\u9700\u8981\u5b9e\u73b0PlayerEvent\u63a5\u53e3. event=" + event.getClass().getSimpleName());
            }
            default: {
                throw new UnrealizedException("\u4e8b\u4ef6\u76d1\u542c\u53d1\u73b0\u4e86\u975e\u6cd5\u7ebf\u7a0b\u6267\u884c\u7ec4:" + (Object)((Object)handler.threadGroup()));
            }
        }
    }

    public void dispatchFixedTimeEvent(EventMethodWrapper handler, FixedTimeEvent event) {
        switch (handler.threadGroup()) {
            case PlayerThreadGroup: {
                for (Serializable playerId : SessionManager.getOnlinePlayerIdList()) {
                    this.dispatchPlayerThreadHandle(null, null, new PlayerThreadCommand(playerId, handler, handler.analysisParam(playerId, event)));
                }
                break;
            }
            case ModuleThreadGroup: {
                this.dispatchSystemThreadHandle(null, null, new SystemThreadCommand(handler.getModule(), handler, handler.analysisParam(null, event)));
                break;
            }
            case QueueThreadGroup: {
                if (event instanceof QueueEvent) {
                    QueueEvent e = (QueueEvent)((Object)event);
                    this.dispatchHandle(null, null, ((QueueEvent)((Object)event)).getQueueId(), new QueueThreadCommand(null, handler, e));
                    break;
                }
                throw new UnrealizedException("\u73a9\u5bb6\u7ebf\u7a0b\u76d1\u542c\u7684\u4e8b\u4ef6\uff0c\u9700\u8981\u5b9e\u73b0PlayerEvent\u63a5\u53e3. event=" + event.getClass().getSimpleName());
            }
            default: {
                throw new UnrealizedException("\u4e8b\u4ef6\u76d1\u542c\u53d1\u73b0\u4e86\u975e\u6cd5\u7ebf\u7a0b\u6267\u884c\u7ec4:" + (Object)((Object)handler.threadGroup()));
            }
        }
    }

    public void dispatchScheduled(ScheduledMethodWrapper handler) {
        switch (handler.threadGroup()) {
            case ModuleThreadGroup: {
                this.dispatchSystemThreadHandle(null, null, new SystemThreadCommand(handler.getModule(), handler, new Object[0]));
                break;
            }
            case PlayerThreadGroup: {
                for (Serializable playerId : SessionManager.getOnlinePlayerIdList()) {
                    this.dispatchPlayerThreadHandle(null, null, new PlayerThreadCommand(playerId, handler, playerId));
                }
                break;
            }
            default: {
                throw new UnrealizedException("@Scheduled\u53ea\u80fd\u5e94\u7528\u5728\u7cfb\u7edf\u6a21\u5757\u6216\u73a9\u5bb6\u6a21\u5757\uff1a" + (Object)((Object)handler.threadGroup()));
            }
        }
    }

    public void shutdown() {
        LogHelper.logger.info("\u5f00\u59cb\u901a\u77e5\u505c\u6b62\u5904\u7406\u4e1a\u52a1\u903b\u8f91\u7684\u7ebf\u7a0b\u6c60\u505c\u6b62\u670d\u52a1.");
        this.businessThreadPool.shutdown();
        try {
            if (!this.businessThreadPool.awaitTermination(10L, TimeUnit.MINUTES)) {
                this.businessThreadPool.shutdownNow();
            }
            LogHelper.logger.info("\u5904\u7406\u4e1a\u52a1\u903b\u8f91\u7684\u7ebf\u7a0b\u6c60\u5df2\u505c\u6b62\u670d\u52a1");
        }
        catch (InterruptedException ie) {
            LogHelper.logger.error("\u505c\u6b62\u5904\u7406\u4e1a\u52a1\u903b\u8f91\u7684\u7ebf\u7a0b\u6c60\u65f6\u53d1\u751f\u5f02\u5e38.", new Object[]{ie});
            this.businessThreadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

