/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import xyz.noark.core.util.MathUtils;

public class MapUtils {
    private MapUtils() {
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return new HashMap(MapUtils.calculateInitialCapacity(size));
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int size) {
        return new ConcurrentHashMap(MapUtils.calculateInitialCapacity(size));
    }

    static int calculateInitialCapacity(int size) {
        return (int)((float)size / 0.75f + 1.0f);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !MapUtils.isEmpty(map);
    }

    public static <K, V> HashMap<K, V> of(K key, V value) {
        HashMap<K, V> result = new HashMap<K, V>(1, 1.0f);
        result.put(key, value);
        return result;
    }

    public static <V> V getOrMaxKey(Map<Integer, V> map, Integer key) {
        V v = map.get(key);
        if (v != null) {
            return v;
        }
        return map.entrySet().stream().filter(x -> (Integer)x.getKey() < key).max(Comparator.comparing(Map.Entry::getKey)).map(Map.Entry::getValue).orElse(null);
    }

    public static <K> void addByIntValue(Map<K, Integer> source, Map<K, Integer> value) {
        if (MapUtils.isNotEmpty(value)) {
            value.forEach((k, v) -> source.merge((Object)k, (Integer)v, (v1, v2) -> MathUtils.addExact(v1, v2)));
        }
    }

    public static <K> void addByLongValue(Map<K, Long> source, Map<K, Long> value) {
        if (MapUtils.isNotEmpty(value)) {
            value.forEach((k, v) -> source.merge((Object)k, (Long)v, (v1, v2) -> MathUtils.addExact(v1, v2)));
        }
    }

    public static <K> Integer addValue(Map<K, Integer> source, K key, int value) {
        return source.compute(key, (k, v) -> v == null ? value : value + v);
    }

    public static <K> Long addValue(Map<K, Long> source, K key, long value) {
        return source.compute(key, (k, v) -> v == null ? value : value + v);
    }

    public static <K> Float addValue(Map<K, Float> source, K key, float value) {
        return source.compute(key, (k, v) -> Float.valueOf(v == null ? value : value + v.floatValue()));
    }

    public static <K> Double addValue(Map<K, Double> source, K key, double value) {
        return source.compute(key, (k, v) -> v == null ? value : value + v);
    }

    @SafeVarargs
    public static <K> double getRatioValue(Map<K, Long> map, double ratio, K ... keys) {
        double result = 0.0;
        for (K key : keys) {
            result += MathUtils.longToDouble(map.getOrDefault(key, 0L), ratio);
        }
        return result;
    }

    @SafeVarargs
    public static <K> double getPermillageValue(Map<K, Long> map, K ... keys) {
        return MapUtils.getRatioValue(map, 1000.0, keys);
    }

    @SafeVarargs
    public static <K> double getPercentageValue(Map<K, Long> map, K ... keys) {
        return MapUtils.getRatioValue(map, 100.0, keys);
    }
}

