/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import xyz.noark.core.lang.Point;
import xyz.noark.core.util.RandomUtils;

public class MathUtils {
    public static final double ONE = 1.0;
    public static final double HUNDRED = 100.0;
    public static final double THOUSAND = 1000.0;
    public static final double TEN_THOUSAND = 10000.0;
    public static final double MILLION = 1000000.0;

    public static int addExact(int x, int y) {
        try {
            return Math.addExact(x, y);
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
    }

    public static long addExact(long x, long y) {
        try {
            return Math.addExact(x, y);
        }
        catch (ArithmeticException e) {
            return Long.MAX_VALUE;
        }
    }

    public static int multiplyExact(int x, int y) {
        try {
            return Math.multiplyExact(x, y);
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
    }

    public static long multiplyExact(long x, long y) {
        try {
            return Math.multiplyExact(x, y);
        }
        catch (ArithmeticException e) {
            return Long.MAX_VALUE;
        }
    }

    public static double distance(int x1, int y1, int x2, int y2) {
        double x = Math.abs(x1 - x2);
        double y = Math.abs(y1 - y2);
        return Math.sqrt(x * x + y * y);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        double x = Math.abs(x1 - x2);
        double y = Math.abs(y1 - y2);
        return Math.sqrt(x * x + y * y);
    }

    public static double distance(Point p1, Point p2) {
        return MathUtils.distance(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static boolean adjacent(int x1, int y1, int x2, int y2) {
        return Math.abs(x1 - x2) <= 1 && Math.abs(y1 - y2) <= 1;
    }

    public static boolean adjacent(Point p1, Point p2) {
        return MathUtils.adjacent(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static int floorInt(double a) {
        return (int)Math.floor(a);
    }

    public static long floorLong(double a) {
        return (long)Math.floor(a);
    }

    public static int ceilInt(double a) {
        return (int)Math.ceil(a);
    }

    public static long ceilLong(double a) {
        return (long)Math.ceil(a);
    }

    public static int roundInt(double a) {
        return (int)Math.round(a);
    }

    public static long roundLong(double a) {
        return Math.round(a);
    }

    public static float formatScale(float value, int newScale) {
        return MathUtils.formatScale(value, newScale, RoundingMode.HALF_UP);
    }

    public static float formatScale(float value, int newScale, RoundingMode mode) {
        return BigDecimal.valueOf(value).setScale(newScale, mode).floatValue();
    }

    public static double formatScale(double value, int newScale) {
        return MathUtils.formatScale(value, newScale, RoundingMode.HALF_UP);
    }

    public static double formatScale(double value, int newScale, RoundingMode mode) {
        return BigDecimal.valueOf(value).setScale(newScale, mode).doubleValue();
    }

    public static <T> Map<T, Long> plunder(Map<T, Long> resources, long max, Map<T, Integer> ratio) {
        HashMap<Object, Long> result = new HashMap<Object, Long>(resources.size());
        int sum = ratio.values().stream().reduce(0, (a, b) -> a + b);
        long step = max >= (long)sum ? max / (long)Math.min(1000, Math.max(10, ratio.values().stream().reduce(0, (a, b) -> a + b))) : max;
        long total = max;
        while (total > 0L) {
            boolean flag = false;
            for (Map.Entry<T, Long> e : resources.entrySet()) {
                long temp;
                if (e.getValue() <= 0L) continue;
                flag = true;
                long selfStep = step * (long)ratio.getOrDefault(e.getKey(), 1).intValue() + RandomUtils.nextLong(step);
                long l = temp = selfStep > total ? total : selfStep;
                if (e.getValue() < temp) {
                    temp = e.getValue();
                }
                long value = temp;
                e.setValue(e.getValue() - value);
                result.compute(e.getKey(), (k, v) -> v == null ? value : v + value);
                if ((total -= temp) > 0L) continue;
                break;
            }
            if (flag) continue;
            break;
        }
        return result;
    }

    public static double longToDouble(long value, double ratio) {
        return (double)value / ratio;
    }

    public static double permillage(long value) {
        return MathUtils.longToDouble(value, 1000.0);
    }

    public static double percentage(long value) {
        return MathUtils.longToDouble(value, 100.0);
    }
}

