/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.lang.management.ManagementFactory;
import xyz.noark.core.util.StringUtils;

public class SystemUtils {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final boolean IS_OS_LINUX = SystemUtils.getOsMatchesName("linux");
    public static final boolean IS_OS_WINDOWS = SystemUtils.getOsMatchesName("win");

    private static boolean getOsMatchesName(String osNamePrefix) {
        return SystemUtils.isOsNameMatch(OS_NAME, osNamePrefix);
    }

    private static boolean isOsNameMatch(String osName, String osNamePrefix) {
        if (StringUtils.isEmpty(osName)) {
            return false;
        }
        return osName.toLowerCase().startsWith(osNamePrefix);
    }

    public static long getPid() {
        return Long.parseLong(SystemUtils.getPidStr());
    }

    public static String getPidStr() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@", 2)[0];
    }
}

