/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.converter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import xyz.noark.core.annotation.TemplateConverter;
import xyz.noark.core.converter.Converter;
import xyz.noark.core.converter.impl.BooleanConverter;
import xyz.noark.core.converter.impl.ByteArrayConverter;
import xyz.noark.core.converter.impl.DateConverter;
import xyz.noark.core.converter.impl.DoubleConverter;
import xyz.noark.core.converter.impl.DoubleListConverter;
import xyz.noark.core.converter.impl.FileSizeConverter;
import xyz.noark.core.converter.impl.FloatConverter;
import xyz.noark.core.converter.impl.FloatListConverter;
import xyz.noark.core.converter.impl.IntListConverter;
import xyz.noark.core.converter.impl.IntPairConverter;
import xyz.noark.core.converter.impl.IntRangeConverter;
import xyz.noark.core.converter.impl.IntSectionConverter;
import xyz.noark.core.converter.impl.IntegerConverter;
import xyz.noark.core.converter.impl.LocalDateConverter;
import xyz.noark.core.converter.impl.LocalDateTimeConverter;
import xyz.noark.core.converter.impl.LocalTimeArrayConverter;
import xyz.noark.core.converter.impl.LocalTimeConverter;
import xyz.noark.core.converter.impl.LocalTimeSectionConverter;
import xyz.noark.core.converter.impl.LongConverter;
import xyz.noark.core.converter.impl.LongListConverter;
import xyz.noark.core.converter.impl.PointConverter;
import xyz.noark.core.converter.impl.PointListConverter;
import xyz.noark.core.converter.impl.StringConverter;
import xyz.noark.core.converter.impl.StringListConverter;
import xyz.noark.core.converter.impl.TimeRangeConverter;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.util.ClassUtils;

public class ConvertManager {
    private static final ConvertManager INSTANCE = new ConvertManager();
    private static final Map<Class<?>, Converter<?>> CONVERTERS = new HashMap(128);

    private ConvertManager() {
    }

    public static ConvertManager getInstance() {
        return INSTANCE;
    }

    public <T> Converter<T> getConverter(Class<T> type) {
        return CONVERTERS.get(type);
    }

    public void register(Class<?> klass, TemplateConverter templateConverter, Object single) {
        if (!(single instanceof Converter)) {
            throw new ServerBootstrapException("\u975e\u6cd5\u7684\u8f6c\u5316\u5668." + klass.getName());
        }
        this.putConvert((Converter)single, templateConverter);
    }

    public void register(Class<? extends Converter<?>> klass) {
        this.putConvert(ClassUtils.newInstance(klass), klass.getAnnotation(TemplateConverter.class));
    }

    private void putConvert(Converter<?> converter, TemplateConverter annotation) {
        for (Class<?> targetClass : annotation.value()) {
            CONVERTERS.put(targetClass, converter);
        }
    }

    public Collection<Converter<?>> getAllBaseConverter() {
        return CONVERTERS.values();
    }

    static {
        INSTANCE.register(BooleanConverter.class);
        INSTANCE.register(ByteArrayConverter.class);
        INSTANCE.register(DateConverter.class);
        INSTANCE.register(DoubleConverter.class);
        INSTANCE.register(DoubleListConverter.class);
        INSTANCE.register(FileSizeConverter.class);
        INSTANCE.register(FloatConverter.class);
        INSTANCE.register(FloatListConverter.class);
        INSTANCE.register(IntegerConverter.class);
        INSTANCE.register(IntListConverter.class);
        INSTANCE.register(IntPairConverter.class);
        INSTANCE.register(IntRangeConverter.class);
        INSTANCE.register(IntSectionConverter.class);
        INSTANCE.register(LocalDateConverter.class);
        INSTANCE.register(LocalDateTimeConverter.class);
        INSTANCE.register(LocalTimeArrayConverter.class);
        INSTANCE.register(LocalTimeConverter.class);
        INSTANCE.register(LocalTimeSectionConverter.class);
        INSTANCE.register(LongConverter.class);
        INSTANCE.register(LongListConverter.class);
        INSTANCE.register(PointConverter.class);
        INSTANCE.register(PointListConverter.class);
        INSTANCE.register(StringConverter.class);
        INSTANCE.register(StringListConverter.class);
        INSTANCE.register(TimeRangeConverter.class);
    }
}

