/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.converter.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.noark.core.annotation.TemplateConverter;
import xyz.noark.core.converter.AbstractConverter;
import xyz.noark.core.exception.IllegalExpressionException;
import xyz.noark.core.lang.FileSize;

@TemplateConverter(value={FileSize.class})
public class FileSizeConverter
extends AbstractConverter<FileSize> {
    private static final Pattern VALUE_PATTERN = Pattern.compile("([0-9]+([\\.,][0-9]+)?)\\s*(|K|M|G)B?", 2);
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final String UNITS_KB = "K";
    private static final String UNITS_MB = "M";
    private static final String UNITS_GB = "G";

    @Override
    public FileSize convert(String string) throws Exception {
        Matcher matcher = VALUE_PATTERN.matcher(string.trim());
        if (matcher.matches()) {
            double value = Double.parseDouble(matcher.group(1));
            String units = matcher.group(3);
            if (units.isEmpty()) {
                return new FileSize(value);
            }
            if (UNITS_KB.equalsIgnoreCase(units)) {
                return new FileSize(value * 1024.0);
            }
            if (UNITS_MB.equalsIgnoreCase(units)) {
                return new FileSize(value * 1048576.0);
            }
            if (UNITS_GB.equalsIgnoreCase(units)) {
                return new FileSize(value * 1.073741824E9);
            }
            throw new IllegalExpressionException("FileSize\u7684\u5355\u4f4d\u53ea\u80fd\u662f(|K|M|G)B?\uff1a" + units);
        }
        throw new IllegalExpressionException("FileSize\u7684\u683c\u5f0f\u9a8c\u8bc1\u5931\u8d25:" + string);
    }

    @Override
    public String buildErrorMsg() {
        return "\u4e0d\u662f\u4e00\u4e2aFileSize\u7c7b\u578b\u7684\u503c";
    }
}

