/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.converter.impl;

import xyz.noark.core.annotation.TemplateConverter;
import xyz.noark.core.converter.AbstractConverter;
import xyz.noark.core.converter.impl.LocalTimeConverter;
import xyz.noark.core.exception.IllegalExpressionException;
import xyz.noark.core.lang.LocalTimeSection;
import xyz.noark.core.util.StringUtils;

@TemplateConverter(value={LocalTimeSection.class})
public class LocalTimeSectionConverter
extends AbstractConverter<LocalTimeSection> {
    private final LocalTimeConverter converter = new LocalTimeConverter();

    @Override
    public String buildErrorMsg() {
        return "\u65f6\u95f4\u8303\u56f4\u8868\u8fbe\u5f0f\uff1a[*][*][*][*][00:00-23:59]";
    }

    @Override
    public LocalTimeSection convert(String value) {
        String[] array = StringUtils.split(value, "-");
        if (array.length == 1) {
            if ("*".equals(array[0])) {
                return new LocalTimeSection();
            }
            throw new IllegalExpressionException("\u65f6\u95f4\u533a\u8868\u8fbe\u5f0f\u683c\u5f0f\u9519\u8bef\uff1a" + value);
        }
        if (array.length == 2) {
            return new LocalTimeSection(this.converter.convert(array[0]), this.converter.convert(array[1]));
        }
        throw new IllegalExpressionException("\u65f6\u95f4\u533a\u8868\u8fbe\u5f0f\u683c\u5f0f\u9519\u8bef\uff1a" + value);
    }
}

