/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import xyz.noark.core.annotation.Component;
import xyz.noark.core.annotation.Configuration;
import xyz.noark.core.annotation.Controller;
import xyz.noark.core.annotation.ModuleController;
import xyz.noark.core.annotation.Profile;
import xyz.noark.core.annotation.StaticComponent;
import xyz.noark.core.annotation.TemplateConverter;
import xyz.noark.core.converter.ConvertManager;
import xyz.noark.core.converter.Converter;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.ioc.BeanDefinition;
import xyz.noark.core.ioc.definition.ConfigurationBeanDefinition;
import xyz.noark.core.ioc.definition.ControllerBeanDefinition;
import xyz.noark.core.ioc.definition.DefaultBeanDefinition;
import xyz.noark.core.ioc.definition.StaticComponentBeanDefinition;
import xyz.noark.core.ioc.scan.Resource;
import xyz.noark.core.ioc.scan.ResourceScanning;
import xyz.noark.core.util.AnnotationUtils;
import xyz.noark.core.util.CharsetUtils;
import xyz.noark.core.util.ClassUtils;
import xyz.noark.core.util.MapUtils;
import xyz.noark.core.util.StringUtils;

public class IocLoader {
    private static final String PACKAGE_INFO_CLASS = "package-info.class";
    private static final String CLASS_SUFFIX = ".class";
    private static final String STARTER_SUFFIX = ".starter";
    private final String profileStr;
    private final HashMap<Class<?>, DefaultBeanDefinition> beans = MapUtils.newHashMap(1024);
    private final List<BeanDefinition> configurations = new ArrayList<BeanDefinition>();
    private final List<StaticComponentBeanDefinition> staticComponents = new ArrayList<StaticComponentBeanDefinition>();

    IocLoader(String profileStr, String ... packages) {
        this.profileStr = profileStr;
        ResourceScanning.scanPackage(packages, this::analysisResource);
        this.initConverterLoader();
    }

    private void initConverterLoader() {
        for (Converter<?> converter : ConvertManager.getInstance().getAllBaseConverter()) {
            Class<?> klass = converter.getClass();
            this.beans.put(klass, new DefaultBeanDefinition(this.profileStr, klass, converter).init());
        }
    }

    protected List<DefaultBeanDefinition> findImpl(Class<?> klass) {
        return this.beans.values().stream().filter(v -> klass.isInstance(v.getSingle())).collect(Collectors.toList());
    }

    private void analysisResource(Resource resource) {
        String resourceName = resource.getName();
        if (resourceName.endsWith(STARTER_SUFFIX)) {
            this.analysisStarter(resourceName);
        } else if (resourceName.endsWith(CLASS_SUFFIX)) {
            if (PACKAGE_INFO_CLASS.equals(resourceName)) {
                return;
            }
            this.analysisClass(resourceName.substring(0, resourceName.length() - 6).replaceAll("[/\\\\]", "."));
        }
    }

    private void analysisStarter(String resourceName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try (InputStream is = classLoader.getResourceAsStream(resourceName);){
            assert (is != null);
            try (InputStreamReader isr = new InputStreamReader(is, CharsetUtils.CHARSET_UTF_8);
                 BufferedReader br = new BufferedReader(isr);){
                br.lines().forEach(this::analysisStarterConfigLine);
            }
        }
        catch (IOException e) {
            throw new ServerBootstrapException("\u89e3\u6790Starter\u914d\u7f6e\u65f6", e);
        }
    }

    private void analysisStarterConfigLine(String line) {
        if (StringUtils.isEmpty(line) || line.startsWith("#")) {
            return;
        }
        this.analysisClass(line);
    }

    private void analysisClass(String className) {
        this.analysisClass(ClassUtils.loadClass(className));
    }

    private void analysisClass(Class<?> klass) {
        if (klass.isInterface() || klass.isMemberClass() || klass.isEnum() || klass.isAnnotation() || klass.isAnonymousClass()) {
            return;
        }
        int modify = klass.getModifiers();
        if (Modifier.isAbstract(modify) || !Modifier.isPublic(modify)) {
            return;
        }
        if (AnnotationUtils.filterProfile(klass.getAnnotation(Profile.class), this.profileStr)) {
            return;
        }
        Annotation annotation = AnnotationUtils.getAnnotation(klass, Component.class);
        if (annotation == null) {
            return;
        }
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (annotationType == Configuration.class) {
            this.configurations.add(new ConfigurationBeanDefinition(this.profileStr, klass).init());
        } else if (annotationType == Controller.class) {
            this.analytical(klass, (Controller)annotation);
        } else if (annotationType == ModuleController.class) {
            this.analytical(klass, (ModuleController)annotation);
        } else if (annotationType == StaticComponent.class) {
            this.staticComponents.add(new StaticComponentBeanDefinition(this.profileStr, klass).init());
        } else {
            DefaultBeanDefinition definition = new DefaultBeanDefinition(this.profileStr, klass, annotation, annotationType).init();
            this.beans.put(klass, definition);
            if (annotationType == TemplateConverter.class) {
                ConvertManager.getInstance().register(klass, (TemplateConverter)annotation, definition.getSingle());
            }
        }
    }

    private void analytical(Class<?> klass, ModuleController controller) {
        this.beans.put(klass, new ControllerBeanDefinition(this.profileStr, klass, controller).init());
    }

    private void analytical(Class<?> klass, Controller controller) {
        this.beans.put(klass, new ControllerBeanDefinition(this.profileStr, klass, controller).init());
    }

    public HashMap<Class<?>, DefaultBeanDefinition> getBeans() {
        return this.beans;
    }

    public List<BeanDefinition> getConfigurations() {
        return this.configurations;
    }

    public List<StaticComponentBeanDefinition> getStaticComponents() {
        return this.staticComponents;
    }
}

