/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import xyz.noark.core.ioc.BeanDefinition;
import xyz.noark.core.ioc.Ioc;
import xyz.noark.core.ioc.IocHolder;
import xyz.noark.core.ioc.IocLoader;
import xyz.noark.core.ioc.IocMaking;
import xyz.noark.core.ioc.definition.DefaultBeanDefinition;
import xyz.noark.core.ioc.manager.EventMethodManager;
import xyz.noark.core.ioc.wrap.MethodWrapper;
import xyz.noark.log.LogHelper;

public class NoarkIoc
implements Ioc {
    private final ConcurrentHashMap<Class<?>, Object> singletons = new ConcurrentHashMap(512);
    private final ConcurrentHashMap<Class<? extends Annotation>, List<MethodWrapper>> customMethods = new ConcurrentHashMap();

    public NoarkIoc(String packager) {
        this(null, packager);
    }

    public NoarkIoc(String profile, String packager) {
        LogHelper.logger.debug("init ioc, packager={}", new Object[]{packager});
        IocHolder.setIoc(this);
        IocLoader loader = new IocLoader(profile, packager);
        try (IocMaking making = new IocMaking(loader);){
            this.finishBeanInitialization(making, loader.getConfigurations());
            this.finishBeanInitialization(making, loader.getBeans().values());
            this.finishBeanInitialization(making, loader.getStaticComponents());
        }
        this.finishBeanAnalysis(loader);
    }

    private void finishBeanAnalysis(IocLoader loader) {
        loader.getBeans().forEach((k, v) -> v.doAnalysisFunction(this));
        EventMethodManager.getInstance().listenerExtend().sort();
        this.customMethods.values().forEach(v -> v.sort(Comparator.comparingInt(MethodWrapper::getOrder)));
        this.singletons.putAll(loader.getBeans().values().stream().collect(Collectors.toMap(DefaultBeanDefinition::getBeanClass, DefaultBeanDefinition::getSingle)));
    }

    private void finishBeanInitialization(IocMaking making, Collection<? extends BeanDefinition> beans) {
        beans.forEach(bean -> bean.injection(making));
    }

    @Override
    public <T> T get(Class<T> klass) {
        return klass.cast(this.singletons.get(klass));
    }

    public void invokeCustomAnnotationMethod(Class<? extends Annotation> klass) {
        this.customMethods.getOrDefault(klass, Collections.emptyList()).forEach(rec$ -> ((MethodWrapper)rec$).invoke(new Object[0]));
    }

    public void addCustomMethod(Class<? extends Annotation> klass, MethodWrapper mw) {
        this.customMethods.computeIfAbsent(klass, key -> new ArrayList()).add(mw);
    }

    public void destroy() {
        this.invokeCustomAnnotationMethod(PreDestroy.class);
    }
}

