/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.definition;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.Component;
import xyz.noark.core.annotation.Order;
import xyz.noark.core.annotation.Profile;
import xyz.noark.core.annotation.Value;
import xyz.noark.core.exception.UnrealizedException;
import xyz.noark.core.ioc.BeanDefinition;
import xyz.noark.core.ioc.FieldDefinition;
import xyz.noark.core.ioc.IocMaking;
import xyz.noark.core.ioc.MethodDefinition;
import xyz.noark.core.ioc.NoarkIoc;
import xyz.noark.core.ioc.definition.field.DefaultFieldDefinition;
import xyz.noark.core.ioc.definition.field.ListFieldDefinition;
import xyz.noark.core.ioc.definition.field.MapFieldDefinition;
import xyz.noark.core.ioc.definition.field.ValueFieldDefinition;
import xyz.noark.core.ioc.definition.method.SimpleMethodDefinition;
import xyz.noark.core.ioc.wrap.method.BaseMethodWrapper;
import xyz.noark.core.util.AnnotationUtils;
import xyz.noark.core.util.ArrayUtils;
import xyz.noark.core.util.ClassUtils;
import xyz.noark.core.util.FieldUtils;
import xyz.noark.core.util.MethodUtils;
import xyz.noark.core.util.StringUtils;
import xyz.noark.reflectasm.MethodAccess;

public class DefaultBeanDefinition
implements BeanDefinition {
    private static final Set<Class<?>> IGNORE_ANNOTATION_BY_METHODS = new HashSet();
    protected final Object single;
    protected final MethodAccess methodAccess;
    protected final HashMap<Class<? extends Annotation>, List<MethodDefinition>> customMethods = new HashMap();
    protected final String profileStr;
    private final Class<?> beanClass;
    private String beanName = "";
    private Annotation annotation;
    private Class<? extends Annotation> annotationType;
    private final int order;
    private final ArrayList<FieldDefinition> autowiredFields = new ArrayList();

    public DefaultBeanDefinition(String profileStr, Class<?> klass) {
        this(profileStr, klass, ClassUtils.newInstance(klass));
    }

    public DefaultBeanDefinition(String profileStr, String beanName, Object object) {
        this(profileStr, object.getClass(), object);
        this.beanName = beanName;
    }

    public DefaultBeanDefinition(String profileStr, Class<?> klass, Object object) {
        this.profileStr = profileStr;
        this.single = object;
        this.beanClass = klass;
        this.methodAccess = MethodAccess.get(this.beanClass);
        Order order = this.beanClass.getAnnotation(Order.class);
        this.order = order == null ? Integer.MAX_VALUE : order.value();
    }

    public DefaultBeanDefinition(String profileStr, Class<?> klass, Annotation annotation, Class<? extends Annotation> annotationType) {
        this(profileStr, klass, ClassUtils.newInstance(klass));
        this.annotation = annotation;
        this.annotationType = annotationType;
    }

    public DefaultBeanDefinition init() {
        this.analysisField();
        this.analysisMethod();
        return this;
    }

    public int[] getIds() {
        if (this.annotationType == Component.class) {
            return ((Component)this.annotation).id();
        }
        throw new UnrealizedException("\u4eb2\uff0c\u53ea\u6709@Component\u624d\u4f1a\u6709\u8fd9\u4e2a\u914d\u7f6e\uff0c\u7528\u4e8eMap\u7684\u6ce8\u5165");
    }

    @Override
    public String[] getNames() {
        if (this.annotationType == Component.class) {
            return ((Component)this.annotation).name();
        }
        if (StringUtils.isNotEmpty(this.beanName)) {
            return new String[]{this.beanName};
        }
        return new String[]{this.beanClass.getName()};
    }

    public Object getSingle() {
        return this.single;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public int getOrder() {
        return this.order;
    }

    private void analysisMethod() {
        List<Method> methods = MethodUtils.getAllMethod(this.beanClass);
        for (Method method : methods) {
            Object[] annotations = method.getAnnotations();
            if (!ArrayUtils.isNotEmpty(annotations) || AnnotationUtils.filterProfile(method.getAnnotation(Profile.class), this.profileStr)) continue;
            for (Object annotation : annotations) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (IGNORE_ANNOTATION_BY_METHODS.contains(annotationType)) continue;
                this.analysisMethodByAnnotation(annotationType, (Annotation)annotation, method);
            }
        }
    }

    protected void analysisMethodByAnnotation(Class<? extends Annotation> annotationType, Annotation annotation, Method method) {
        this.customMethods.computeIfAbsent(annotationType, key -> new ArrayList(64)).add(new SimpleMethodDefinition(this.methodAccess, method));
    }

    private void analysisField() {
        FieldUtils.getAllField(this.beanClass).stream().filter(v -> v.isAnnotationPresent(Autowired.class) || v.isAnnotationPresent(Value.class)).forEach(this::analysisAutowiredOrValue);
    }

    private void analysisAutowiredOrValue(Field field) {
        Class<?> fieldClass = field.getType();
        Value value = field.getAnnotation(Value.class);
        if (value == null) {
            Autowired autowired = field.getAnnotation(Autowired.class);
            if (fieldClass == List.class) {
                this.autowiredFields.add(new ListFieldDefinition(field, autowired.required()));
            } else if (fieldClass == Map.class) {
                this.autowiredFields.add(new MapFieldDefinition(field, autowired.required()));
            } else {
                this.autowiredFields.add(new DefaultFieldDefinition(field, autowired.required()));
            }
        } else {
            this.autowiredFields.add(new ValueFieldDefinition(field, value.value()));
        }
    }

    @Override
    public void injection(IocMaking making) {
        this.autowiredFields.forEach(v -> v.injection(this.single, making));
    }

    public void doAnalysisFunction(NoarkIoc ioc) {
        this.customMethods.forEach((k, list) -> list.forEach(v -> ioc.addCustomMethod((Class<? extends Annotation>)k, new BaseMethodWrapper(this.single, v.getMethodAccess(), v.getMethodIndex(), v.getOrder()))));
    }

    static {
        IGNORE_ANNOTATION_BY_METHODS.add(Deprecated.class);
    }
}

