/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.definition.method;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import xyz.noark.core.annotation.controller.CommandMapping;
import xyz.noark.core.annotation.controller.PacketMapping;
import xyz.noark.core.ioc.definition.method.SimpleMethodDefinition;
import xyz.noark.core.network.Session;
import xyz.noark.reflectasm.MethodAccess;

public class PacketMethodDefinition
extends SimpleMethodDefinition {
    private final Parameter[] parameters;
    private final Serializable opcode;
    private final boolean printLog;
    private final boolean inner;
    private final Set<Session.State> stateSet;

    public PacketMethodDefinition(MethodAccess methodAccess, Method method, PacketMapping packetMapping) {
        super(methodAccess, method);
        this.parameters = method.getParameters();
        this.opcode = Integer.valueOf(packetMapping.opcode());
        this.printLog = packetMapping.printLog();
        this.inner = packetMapping.inner();
        this.stateSet = new HashSet<Session.State>(Arrays.asList(packetMapping.state()));
    }

    public PacketMethodDefinition(MethodAccess methodAccess, Method method, CommandMapping commandMapping) {
        super(methodAccess, method);
        this.parameters = method.getParameters();
        this.opcode = commandMapping.opcode();
        this.printLog = commandMapping.printLog();
        this.inner = commandMapping.inner();
        this.stateSet = new HashSet<Session.State>(Arrays.asList(commandMapping.state()));
    }

    public Serializable getOpcode() {
        return this.opcode;
    }

    public boolean isPrintLog() {
        return this.printLog;
    }

    public boolean isInnerPacket() {
        return this.inner;
    }

    public Set<Session.State> getStateSet() {
        return this.stateSet;
    }

    @Override
    public Parameter[] getParameters() {
        return this.parameters;
    }
}

