/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.manager;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.ioc.wrap.method.PacketMethodWrapper;
import xyz.noark.core.lang.MutableBoolean;
import xyz.noark.core.network.NetworkPacket;
import xyz.noark.core.network.PacketHelper;
import xyz.noark.core.network.Session;
import xyz.noark.core.util.StringUtils;
import xyz.noark.log.LogHelper;

public class PacketMethodManager {
    private static final PacketMethodManager INSTANCE = new PacketMethodManager();
    private final ConcurrentMap<Serializable, PacketMethodWrapper> handlers = new ConcurrentHashMap<Serializable, PacketMethodWrapper>(2048);

    private PacketMethodManager() {
    }

    public static PacketMethodManager getInstance() {
        return INSTANCE;
    }

    public void resetPacketHandler(PacketMethodWrapper handler) {
        if (this.handlers.containsKey(handler.getOpcode())) {
            throw new ServerBootstrapException("\u91cd\u590d\u5b9a\u4e49\u7684 Opcode\uff1a" + handler.getOpcode());
        }
        this.handlers.put(handler.getOpcode(), handler);
    }

    public PacketMethodWrapper getPacketMethodWrapper(Serializable opcode) {
        return (PacketMethodWrapper)this.handlers.get(opcode);
    }

    public boolean temporarilyClosed(Serializable opcode) {
        PacketMethodWrapper method = this.getPacketMethodWrapper(opcode);
        if (method == null) {
            return false;
        }
        method.setDeprecated(true);
        return true;
    }

    public boolean temporaryOpening(Serializable opcode) {
        PacketMethodWrapper method = this.getPacketMethodWrapper(opcode);
        if (method == null) {
            return false;
        }
        method.setDeprecated(false);
        return true;
    }

    public void outputStatInfo(int maxSize) {
        HashMap result = new HashMap(this.handlers.size());
        for (Map.Entry e2 : this.handlers.entrySet()) {
            long num = ((PacketMethodWrapper)e2.getValue()).getCallNum();
            if (num <= 0L) continue;
            result.put(e2.getKey(), num);
        }
        result.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(maxSize).forEachOrdered(e -> LogHelper.logger.info("protocol stat. opcode={}, call={}", new Object[]{e.getKey(), e.getValue()}));
    }

    public boolean logPacket(Session session, NetworkPacket packet) {
        if (packet == null) {
            return true;
        }
        PacketHelper.tryDecode(session.getPacketEncrypt(), packet);
        Serializable sessionStr = this.analysisSession(session);
        MutableBoolean parsingFailedFlag = new MutableBoolean(false);
        String packetStr = this.analysisPacket(session, packet, parsingFailedFlag);
        LogHelper.logger.warn("^(oo)^ packet info. session={}, packet={}", new Object[]{sessionStr, packetStr});
        return parsingFailedFlag.getValue();
    }

    private Serializable analysisSession(Session session) {
        if (session == null) {
            return "null";
        }
        return session.getId();
    }

    private String analysisPacket(Session session, NetworkPacket packet, MutableBoolean parsingFailedFlag) {
        PacketMethodWrapper pmw = INSTANCE.getPacketMethodWrapper(packet.getOpcode());
        if (pmw == null) {
            return StringUtils.join("illegal opcode:", packet.getOpcode().toString());
        }
        try {
            return pmw.toString(session, packet);
        }
        catch (Exception e) {
            parsingFailedFlag.setValue(true);
            return "Illegal packet:" + Arrays.toString(packet.getByteArray().array());
        }
    }
}

