/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.wrap.method;

import java.io.Serializable;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import xyz.noark.core.annotation.PlayerId;
import xyz.noark.core.annotation.controller.ExecThreadGroup;
import xyz.noark.core.event.Event;
import xyz.noark.core.event.FixedTimeEvent;
import xyz.noark.core.ioc.definition.method.EventMethodDefinition;
import xyz.noark.core.ioc.wrap.ParamWrapper;
import xyz.noark.core.ioc.wrap.method.AbstractControllerMethodWrapper;
import xyz.noark.core.ioc.wrap.param.ObjectParamWrapper;
import xyz.noark.core.ioc.wrap.param.PlayerIdParamWrapper;

public class EventMethodWrapper
extends AbstractControllerMethodWrapper
implements Comparable<EventMethodWrapper> {
    private final Class<? extends Event> eventClass;
    private final ArrayList<ParamWrapper> parameters;
    private final boolean async;

    public EventMethodWrapper(Object single, EventMethodDefinition emd, ExecThreadGroup threadGroup, Class<?> controllerMasterClass) {
        super(single, threadGroup, controllerMasterClass.getName(), EventMethodWrapper.buildLogCode(single, emd), emd);
        this.eventClass = emd.getEventClass();
        this.printLog = emd.isPrintLog();
        this.async = emd.isAsync();
        this.parameters = new ArrayList(emd.getParameters().length);
        Arrays.stream(emd.getParameters()).forEach(this::buildParamWrapper);
    }

    private static String buildLogCode(Object single, EventMethodDefinition emd) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("event[");
        sb.append(single.getClass().getSimpleName()).append('#');
        sb.append(emd.getMethod().getName()).append('(');
        sb.append(emd.getEventClass().getSimpleName()).append(')');
        return sb.append(']').toString();
    }

    private void buildParamWrapper(Parameter parameter) {
        if (parameter.isAnnotationPresent(PlayerId.class)) {
            this.parameters.add(new PlayerIdParamWrapper());
        } else {
            this.parameters.add(new ObjectParamWrapper());
        }
    }

    public Object[] analysisParam(Serializable playerId, FixedTimeEvent event) {
        ArrayList<Object> args = new ArrayList<Object>(this.parameters.size());
        for (ParamWrapper parameter : this.parameters) {
            args.add(parameter.read(playerId, event));
        }
        return args.toArray();
    }

    public Class<? extends Event> getEventClass() {
        return this.eventClass;
    }

    public boolean isAsync() {
        return this.async;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int compareTo(EventMethodWrapper o) {
        if (this.async == o.isAsync()) {
            return Integer.compare(this.getOrder(), o.getOrder());
        }
        return this.async ? 1 : -1;
    }

    public String toString() {
        return "EventMethodWrapper [async=" + this.async + ", method=" + this.methodAccess.getMethodNames()[this.methodIndex] + "]";
    }
}

