/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.wrap.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import xyz.noark.core.annotation.controller.ExecThreadGroup;
import xyz.noark.core.annotation.controller.RequestMethod;
import xyz.noark.core.annotation.controller.RequestParam;
import xyz.noark.core.annotation.controller.ResponseBody;
import xyz.noark.core.ioc.definition.method.HttpMethodDefinition;
import xyz.noark.core.ioc.wrap.method.AbstractControllerMethodWrapper;
import xyz.noark.core.ioc.wrap.param.HttpParamWrapper;
import xyz.noark.core.network.HandlerMethod;

public class HttpMethodWrapper
extends AbstractControllerMethodWrapper
implements HandlerMethod {
    private final String path;
    private final Method method;
    private final Set<RequestMethod> methodSet;
    private final ArrayList<HttpParamWrapper> parameters = new ArrayList();
    private final ResponseBody responseBody;

    public HttpMethodWrapper(Object single, HttpMethodDefinition method, ExecThreadGroup threadGroup, Class<?> controllerMasterClass) {
        super(single, threadGroup, controllerMasterClass.getName(), "handle(" + method.getPath() + ")", method);
        this.path = method.getPath();
        this.method = method.getMethod();
        this.printLog = method.isPrintLog();
        this.queueIdKey = method.getQueueId();
        this.methodSet = method.getMethodSet();
        this.deprecated = method.isDeprecated();
        this.responseBody = method.getResponseBody();
        Arrays.stream(method.getParameters()).forEach(this::buildParamWrapper);
    }

    private void buildParamWrapper(Parameter parameter) {
        RequestParam requestParam = parameter.getAnnotation(RequestParam.class);
        this.parameters.add(new HttpParamWrapper(requestParam, parameter));
    }

    public String getPath() {
        return this.path;
    }

    public ArrayList<HttpParamWrapper> getParameters() {
        return this.parameters;
    }

    public ResponseBody getResponseBody() {
        return this.responseBody;
    }

    public Set<RequestMethod> getMethodSet() {
        return this.methodSet;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.method.getAnnotation(annotationClass);
    }
}

