/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.wrap.method;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import xyz.noark.core.annotation.controller.ExecThreadGroup;
import xyz.noark.core.annotation.controller.Scheduled;
import xyz.noark.core.cron.DelayTrigger;
import xyz.noark.core.cron.DelayTriggerFactory;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.ioc.definition.method.ScheduledMethodDefinition;
import xyz.noark.core.ioc.wrap.method.AbstractControllerMethodWrapper;
import xyz.noark.core.util.StringUtils;

public class ScheduledMethodWrapper
extends AbstractControllerMethodWrapper {
    private static final AtomicLong AUTO_ID = new AtomicLong(0L);
    private final Long id = AUTO_ID.incrementAndGet();
    private final DelayTrigger trigger;

    public ScheduledMethodWrapper(Object single, ScheduledMethodDefinition smd, ExecThreadGroup threadGroup, Class<?> controllerMasterClass) {
        super(single, threadGroup, controllerMasterClass.getName(), "scheduled(" + smd.getMethodName() + ")", smd);
        Scheduled scheduled = smd.getScheduled();
        if (scheduled.fixedRate() <= 0L && StringUtils.isEmpty(scheduled.cron())) {
            String position = single.getClass().getName() + "[" + smd.getMethodName() + "]";
            throw new ServerBootstrapException("@Scheduled\u6ca1\u6709\u914d\u7f6e\u53c2\u6570\uff1a" + position + "\uff0c\u8bf7\u706b\u901f\u5904\u7406...");
        }
        this.trigger = DelayTriggerFactory.create(scheduled);
    }

    public Long getId() {
        return this.id;
    }

    public Date nextExecutionTime() {
        return this.trigger.nextExecutionTime();
    }
}

