/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.wrap.param;

import java.io.Serializable;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.ioc.wrap.ParamWrapper;
import xyz.noark.core.ioc.wrap.method.PacketMethodWrapper;
import xyz.noark.core.network.NetworkPacket;
import xyz.noark.core.network.PacketCodecHolder;
import xyz.noark.core.network.Session;
import xyz.noark.core.util.StringUtils;

public class PacketParamWrapper
implements ParamWrapper {
    private final Class<?> klass;

    public PacketParamWrapper(Class<?> klass, PacketMethodWrapper packetMethod) {
        this.klass = klass;
        if (klass == Long.class || klass == Long.TYPE || klass == String.class || klass == Integer.TYPE || klass == Integer.class) {
            throw new ServerBootstrapException("\u4eb2\uff0c\u4f60\u662f\u4e0d\u662f\u5c11\u4e86\u4e2a@PlayerId\u4e86... " + packetMethod.getTipsInfo());
        }
    }

    @Override
    public Object read(Session session, NetworkPacket packet) {
        return PacketCodecHolder.getPacketCodec().decodeProtocol(packet.getByteArray(), this.klass);
    }

    @Override
    public String toString(Session session, NetworkPacket packet) {
        Object object = this.read(session, packet);
        if (object == null) {
            return "protocol=null";
        }
        String protocol = object.toString();
        if (StringUtils.isNotEmpty(protocol)) {
            protocol = protocol.replace('\n', ',');
            protocol = protocol.substring(0, protocol.length() - 1);
        }
        return StringUtils.join("protocol={", protocol, "}");
    }

    @Override
    public Object read(Serializable playerId, Object protocol) {
        return protocol;
    }
}

