/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import xyz.noark.core.lang.Point;

public class Img {
    private final int width;
    private final int height;
    private BufferedImage image;
    private Graphics2D graphics;

    public Img(int width, int height) {
        this.width = width;
        this.height = height;
        this.image = new BufferedImage(width, height, 6);
        this.graphics = this.image.createGraphics();
    }

    public void drawString(String text, int x, int y, Color color) {
        this.graphics.setColor(color);
        this.graphics.drawString(text, x, y);
    }

    public void drawString(String text, Point point, Color color) {
        this.drawString(text, point.getX(), point.getY(), color);
    }

    public void drawInt(int num, int x, int y, Color color) {
        this.drawString(String.valueOf(num), x, y, color);
    }

    public void drawInt(int num, Point point, Color color) {
        this.drawInt(num, point.getX(), point.getY(), color);
    }

    public void save(String path) throws IOException {
        this.graphics.dispose();
        ImageIO.write((RenderedImage)this.image, "png", new File(path));
    }
}

