/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import xyz.noark.core.exception.ConvertException;
import xyz.noark.core.util.DateUtils;

public class LocalTimeArray {
    private static final int MAX_SECOND_BY_DAY = 86399;
    private final LocalTime[] array;

    public LocalTimeArray(LocalTime[] array) {
        this.array = array;
    }

    public LocalTime[] getArray() {
        return this.array;
    }

    public Date doNext() {
        return this.doNext(LocalTime.now());
    }

    public Date doNext(LocalTime now) {
        return this.doNext(null, now);
    }

    public Date doNext(LocalDate start) {
        return this.doNext(start, LocalTime.now());
    }

    public Date doNext(LocalDate start, LocalTime now) {
        boolean flag = start != null && start.isAfter(LocalDate.now());
        int minSecond = 86399;
        int nextSecond = 86399;
        int todaySecond = now.toSecondOfDay();
        for (LocalTime time : this.array) {
            int targetSecond = time.toSecondOfDay();
            minSecond = Math.min(minSecond, targetSecond);
            if (flag || targetSecond <= todaySecond) continue;
            nextSecond = Math.min(nextSecond, targetSecond - todaySecond);
        }
        if (nextSecond == 86399) {
            nextSecond = 86400 - todaySecond + minSecond;
        }
        Calendar calendar = Calendar.getInstance();
        if (flag) {
            calendar.set(1, start.getYear());
            calendar.set(2, start.getMonthValue() - 1);
            calendar.set(5, start.getDayOfMonth() - 1);
        }
        calendar.set(11, now.getHour());
        calendar.set(12, now.getMinute());
        calendar.set(13, now.getSecond());
        calendar.add(13, nextSecond);
        return calendar.getTime();
    }

    public int triggerTimes(Date lastTriggerTime, Date now) {
        if (lastTriggerTime.getTime() >= now.getTime()) {
            return 0;
        }
        int lastTriggerSecond = DateUtils.toLocalTime(lastTriggerTime).toSecondOfDay();
        int nowSecond = DateUtils.toLocalTime(now).toSecondOfDay();
        long days = DateUtils.diffDays(now, lastTriggerTime);
        int result = 0;
        for (LocalTime time : this.array) {
            int targetSecond = time.toSecondOfDay();
            if (days > 0L) {
                if (targetSecond <= nowSecond) {
                    ++result;
                }
                if (lastTriggerSecond >= targetSecond) continue;
                ++result;
                continue;
            }
            if (lastTriggerSecond >= targetSecond || targetSecond > nowSecond) continue;
            ++result;
        }
        if (days > 1L) {
            result = (int)((long)result + (days - 1L) * (long)this.array.length);
        }
        return result;
    }

    public boolean inSection(LocalTime localTime) {
        if (this.array.length != 2) {
            throw new ConvertException("\u53ea\u6709\u914d\u7f6e\u4e24\u4e2a\u65f6\u95f4\uff0c\u8fd8\u53ef\u4ee5\u4f7f\u7528\u6b64\u65b9\u6cd5" + this);
        }
        long startTime = this.array[0].toSecondOfDay();
        long endTime = this.array[1].toSecondOfDay();
        long now = localTime.toSecondOfDay();
        return startTime <= now && now <= endTime;
    }

    public String toString() {
        return "LocalTimeArray [array=" + Arrays.toString(this.array) + "]";
    }
}

