/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import xyz.noark.core.lang.Mutable;

public class MutableFloat
extends Number
implements Comparable<MutableFloat>,
Mutable<Number> {
    private static final long serialVersionUID = 6389399708303883071L;
    private float value;

    public MutableFloat() {
    }

    public MutableFloat(float value) {
        this.value = value;
    }

    public MutableFloat(Number value) {
        this(value.intValue());
    }

    public MutableFloat(String value) {
        this.value = Float.parseFloat(value);
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public void setValue(Number value) {
        this.value = value.floatValue();
    }

    @Override
    public void setValue(float value) {
        this.value = value;
    }

    @Override
    public int compareTo(MutableFloat anotherInteger) {
        return Float.compare(this.value, anotherInteger.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableFloat) {
            return this.value == ((MutableFloat)obj).floatValue();
        }
        return false;
    }

    public String toString() {
        return Float.toString(this.value);
    }

    public final float getAndIncrement() {
        float oldValue = this.value;
        this.value += 1.0f;
        return oldValue;
    }

    public final float getAndDecrement() {
        float oldValue = this.value;
        this.value -= 1.0f;
        return oldValue;
    }

    public final float getAndAdd(float delta) {
        float oldValue = this.value;
        this.value += delta;
        return oldValue;
    }

    public final float incrementAndGet() {
        return this.value += 1.0f;
    }

    public final float decrementAndGet() {
        return this.value -= 1.0f;
    }

    public final float addAndGet(float delta) {
        return this.value += delta;
    }
}

