/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import xyz.noark.core.lang.ByteArray;
import xyz.noark.core.util.StringUtils;

public class StringByteArray
implements ByteArray {
    private final String text;
    private byte[] cacheArray;

    public StringByteArray(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public byte[] array() {
        this.cacheArrayData();
        return this.cacheArray;
    }

    @Override
    public int length() {
        return this.text.length();
    }

    @Override
    public byte getByte(int index) {
        this.cacheArrayData();
        return this.cacheArray[index];
    }

    @Override
    public void setByte(int index, byte value) {
        this.cacheArrayData();
        this.cacheArray[index] = value;
    }

    private void cacheArrayData() {
        if (this.cacheArray == null) {
            this.cacheArray = StringUtils.utf8Bytes(this.text);
        }
    }

    @Override
    public void close() {
    }
}

