/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import java.time.LocalDateTime;
import xyz.noark.core.converter.impl.LocalTimeSectionConverter;
import xyz.noark.core.lang.BracketParser;
import xyz.noark.core.lang.IntRange;
import xyz.noark.core.lang.LocalTimeSection;
import xyz.noark.core.lang.ValidTime;

public class TimeRange
implements ValidTime {
    private IntRange year;
    private IntRange month;
    private IntRange day;
    private IntRange dayOfWeek;
    private LocalTimeSection timeSection;

    public TimeRange(String expression) {
        BracketParser parser = new BracketParser(expression);
        this.year = new IntRange(parser.readString());
        this.month = new IntRange(parser.readString());
        this.day = new IntRange(parser.readString());
        this.dayOfWeek = new IntRange(parser.readString());
        this.timeSection = new LocalTimeSectionConverter().convert(parser.readString());
    }

    @Override
    public boolean isValid(LocalDateTime time) {
        if (!this.year.contains(time.getYear())) {
            return false;
        }
        if (!this.month.contains(time.getMonthValue())) {
            return false;
        }
        if (!this.day.contains(time.getDayOfMonth())) {
            return false;
        }
        if (!this.dayOfWeek.contains(time.getDayOfWeek().getValue())) {
            return false;
        }
        return this.timeSection.isValid(time.toLocalTime());
    }
}

