/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class UnicodeInputStream
extends InputStream {
    private static final int BOM_SIZE = 4;
    private static final byte BOM_0X00 = 0;
    private static final byte BOM_0XFF = -1;
    private static final byte BOM_0XFE = -2;
    private static final byte BOM_0XEF = -17;
    private static final byte BOM_0XBB = -69;
    private static final byte BOM_0XBF = -65;
    private final PushbackInputStream pis;
    private final String defaultEncoding;
    private String encoding;

    public UnicodeInputStream(InputStream in, String defaultEncoding) throws IOException {
        this.pis = new PushbackInputStream(in, 4);
        this.defaultEncoding = defaultEncoding;
        this.pretreatment();
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected void pretreatment() throws IOException {
        int unread;
        byte[] bom = new byte[4];
        int n = this.pis.read(bom, 0, bom.length);
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            this.encoding = "UTF-32BE";
            unread = n - 4;
        } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            this.encoding = "UTF-32LE";
            unread = n - 4;
        } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            this.encoding = "UTF-8";
            unread = n - 3;
        } else if (bom[0] == -2 && bom[1] == -1) {
            this.encoding = "UTF-16BE";
            unread = n - 2;
        } else if (bom[0] == -1 && bom[1] == -2) {
            this.encoding = "UTF-16LE";
            unread = n - 2;
        } else {
            this.encoding = this.defaultEncoding;
            unread = n;
        }
        if (unread > 0) {
            this.pis.unread(bom, n - unread, unread);
        }
    }

    @Override
    public int read() throws IOException {
        return this.pis.read();
    }

    @Override
    public void close() throws IOException {
        this.pis.close();
    }
}

