/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.thread;

import java.io.Serializable;
import xyz.noark.core.exception.ExceptionHelper;
import xyz.noark.core.network.NetworkPacket;
import xyz.noark.core.network.ResultHelper;
import xyz.noark.core.network.Session;
import xyz.noark.core.thread.AbstractAsyncTask;
import xyz.noark.core.thread.TaskQueue;
import xyz.noark.core.thread.ThreadCommand;
import xyz.noark.core.util.DateUtils;
import xyz.noark.core.util.ThreadUtils;
import xyz.noark.log.LogHelper;

public class AsyncQueueTask
extends AbstractAsyncTask
implements Runnable {
    protected final TaskQueue taskQueue;
    private final ThreadCommand command;
    private final NetworkPacket packet;
    private final Session session;
    private Thread currentThread;

    public AsyncQueueTask(TaskQueue taskQueue, ThreadCommand command, Serializable playerId) {
        this(taskQueue, command, playerId, null, null);
    }

    public AsyncQueueTask(TaskQueue taskQueue, ThreadCommand command, Serializable playerId, NetworkPacket packet, Session session) {
        super(taskQueue.getId(), playerId);
        this.taskQueue = taskQueue;
        this.command = command;
        this.session = session;
        this.packet = packet;
    }

    @Override
    protected void execCommandBefore() {
        this.currentThread = Thread.currentThread();
        super.execCommandBefore();
    }

    @Override
    protected void doSomething() {
        ResultHelper.trySendResult(this.session, this.packet, this.command.exec());
    }

    @Override
    protected void execCommandException(Throwable e) {
        super.execCommandException(e);
        ExceptionHelper.monitor(this.session, this.packet, e);
    }

    @Override
    protected void execCommandAfter(long startExecuteTime) {
        this.taskQueue.complete();
        super.execCommandAfter(startExecuteTime);
    }

    @Override
    protected String logCode() {
        return this.command.code();
    }

    @Override
    protected boolean isPrintLog() {
        return this.command.isPrintLog();
    }

    public void logExecTimeoutInfo(boolean outputStack) {
        float delay = DateUtils.formatNanoTime(this.startExecuteTime - this.createTime);
        float exec = DateUtils.formatNanoTime(System.nanoTime() - this.startExecuteTime);
        if (this.playerId == null) {
            LogHelper.logger.error("exec timeout {},delay={} ms,exec={} ms", new Object[]{this.command.code(), Float.valueOf(delay), Float.valueOf(exec)});
        } else {
            LogHelper.logger.error("exec timeout {},delay={} ms,exec={} ms playerId={}", new Object[]{this.command.code(), Float.valueOf(delay), Float.valueOf(exec), this.playerId});
        }
        if (outputStack) {
            LogHelper.logger.error(ThreadUtils.printStackTrace(this.currentThread));
        }
    }
}

