/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import xyz.noark.core.lang.PairHashMap;
import xyz.noark.core.lang.PairMap;
import xyz.noark.core.util.MapUtils;

public class CollectionUtils {
    public static <V> HashSet<V> newHashSet(int size) {
        return new HashSet(MapUtils.calculateInitialCapacity(size));
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static <K, V> Map<K, List<V>> groupingBy(Collection<V> collection, Function<? super V, ? extends K> keyMapper) {
        return collection.stream().collect(Collectors.groupingBy(keyMapper));
    }

    public static <L, R, V> PairMap<L, R, List<V>> groupingBy(Collection<V> collection, Function<? super V, ? extends L> leftMapper, Function<? super V, ? extends R> rightMapper) {
        PairHashMap result = new PairHashMap();
        collection.forEach(t -> result.computeIfAbsent(leftMapper.apply((Object)t), rightMapper.apply((Object)t), () -> new ArrayList()).add(t));
        return result;
    }

    public static <V> Optional<V> matching(Collection<V> collection, Function<V, ? extends Long> keyMapper, long value) {
        return collection.stream().filter(v -> (Long)keyMapper.apply(v) <= value).max(Comparator.comparing(keyMapper));
    }

    public static <V> Optional<V> matching(Collection<V> collection, Function<V, ? extends Integer> keyMapper, int value) {
        return collection.stream().filter(v -> (Integer)keyMapper.apply(v) <= value).max(Comparator.comparing(keyMapper));
    }

    public static int sumByInt(Collection<Integer> collection) {
        int sum = 0;
        for (int i : collection) {
            sum += i;
        }
        return sum;
    }

    public static long sumByLong(Collection<Long> collection) {
        long sum = 0L;
        for (long i : collection) {
            sum += i;
        }
        return sum;
    }

    public static int size(Collection<?> collection) {
        return collection == null ? 0 : collection.size();
    }

    public static <K, T> HashMap<K, T> toHashMap(Collection<T> list, Function<? super T, ? extends K> keyMapper) {
        return list.stream().collect(Collectors.toMap(keyMapper, Function.identity(), CollectionUtils.throwingMerger(), HashMap::new));
    }

    public static <K, T> LinkedHashMap<K, T> toLinkedHashMap(Collection<T> list, Function<? super T, ? extends K> keyMapper) {
        return list.stream().collect(Collectors.toMap(keyMapper, Function.identity(), CollectionUtils.throwingMerger(), LinkedHashMap::new));
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }
}

