/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.Optional;
import xyz.noark.core.util.CharsetUtils;
import xyz.noark.core.util.StringUtils;

public class FileUtils {
    private static final String[] UNITS = new String[]{"B", "KB", "MB", "GB", "TB", "EB"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> loadFileText(String fileName) {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);){
            Optional<String> optional = Optional.ofNullable(StringUtils.readString(is));
            return optional;
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static String readFileText(String fileName) throws FileNotFoundException, IOException {
        try (FileReader reader = new FileReader(fileName);){
            String string = StringUtils.readString(reader);
            return string;
        }
    }

    public static void writeFileText(String fileName, String content) throws IOException {
        FileUtils.writeFileText(fileName, false, content);
    }

    public static void writeFileText(String fileName, boolean append, String content) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName, append);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, CharsetUtils.CHARSET_UTF_8);){
            osw.write(content);
            osw.flush();
        }
    }

    public static void writerFile(String fileName, byte[] data, boolean append) throws IOException {
        File file = new File(fileName);
        FileUtils.createNewFile(file);
        try (FileOutputStream fos = new FileOutputStream(file, append);
             BufferedOutputStream out = new BufferedOutputStream(fos);){
            ((OutputStream)out).write(data);
            ((OutputStream)out).flush();
        }
    }

    public static String readableFileSize(File file) {
        return FileUtils.readableFileSize(file.length());
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1024.0, digitGroups)) + " " + UNITS[digitGroups];
    }

    public static boolean createNewFile(File file) throws IOException {
        if (file.exists()) {
            return false;
        }
        File parentDir = file.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        return file.createNewFile();
    }
}

