/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import xyz.noark.core.exception.HttpAccessException;
import xyz.noark.core.util.CharsetUtils;
import xyz.noark.core.util.GzipUtils;
import xyz.noark.core.util.MapUtils;
import xyz.noark.core.util.StringUtils;
import xyz.noark.log.LogHelper;

public class HttpUtils {
    static final int DEFAULT_TIMEOUT = 3000;

    public static String get(String url) throws IOException {
        return HttpUtils.get(url, 3000, Collections.emptyMap());
    }

    public static String get(String url, Charset responseCharset) throws IOException {
        return HttpUtils.get(url, 3000, Collections.emptyMap(), responseCharset);
    }

    public static String get(String url, int timeout) throws IOException {
        return HttpUtils.get(url, timeout, Collections.emptyMap());
    }

    public static String get(String url, Map<String, String> requestProperty) throws IOException {
        return HttpUtils.get(url, 3000, requestProperty);
    }

    public static String get(String url, int timeout, Map<String, String> requestProperty) throws IOException {
        return HttpUtils.get(url, timeout, requestProperty, CharsetUtils.CHARSET_UTF_8);
    }

    public static String get(String url, int timeout, Map<String, String> requestProperty, Charset responseCharset) throws IOException {
        URLConnection connection = new URL(url).openConnection();
        connection.setReadTimeout(timeout);
        requestProperty.forEach(connection::setRequestProperty);
        connection.connect();
        return HttpUtils.handleResponseText(connection, responseCharset);
    }

    public static String post(String url, String params) {
        return HttpUtils.post(url, params, 3000, Collections.emptyMap());
    }

    public static String post(String url, String params, Charset responseCharset) {
        return HttpUtils.post(url, params, 3000, Collections.emptyMap(), responseCharset);
    }

    public static String post(String url, String params, int timeout) {
        return HttpUtils.post(url, params, timeout, Collections.emptyMap());
    }

    public static String post(String url, String params, Map<String, String> requestProperty) {
        return HttpUtils.post(url, params, 3000, requestProperty);
    }

    public static String post(String url, String params, int timeout, Map<String, String> requestProperty) {
        return HttpUtils.post(url, params, timeout, requestProperty, CharsetUtils.CHARSET_UTF_8);
    }

    public static String post(String url, String params, int timeout, Map<String, String> requestProperty, Charset responseCharset) {
        LogHelper.logger.info("POST: url={}, param={}", new Object[]{url, params});
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("POST");
            connection.setReadTimeout(timeout);
            requestProperty.forEach(connection::setRequestProperty);
            HttpUtils.buildPostParamsAndSend(connection, params, requestProperty);
            return HttpUtils.handleResponseText(connection, responseCharset);
        }
        catch (Exception e) {
            throw new HttpAccessException(e);
        }
    }

    static void buildPostParamsAndSend(URLConnection connection, String params, Map<String, String> requestProperty) throws IOException {
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.connect();
        if (StringUtils.isNotEmpty(params)) {
            String encoding = requestProperty.get("Content-Encoding");
            if ("gzip".equalsIgnoreCase(encoding)) {
                try (OutputStream out = connection.getOutputStream();){
                    byte[] bytes = params.getBytes(StandardCharsets.UTF_8);
                    out.write(GzipUtils.compress(bytes));
                    out.flush();
                }
            }
            try (PrintWriter out = new PrintWriter(connection.getOutputStream());){
                out.print(params);
                out.flush();
            }
        }
    }

    public static String postJson(String url, String json) {
        return HttpUtils.postJson(url, json, 3000);
    }

    public static String postJson(String url, String json, int timeout) {
        return HttpUtils.post(url, json, timeout, MapUtils.of("Content-Type", "application/json"));
    }

    public static String postGzipJson(String url, String json, int timeout) {
        HashMap<String, String> requestProperty = MapUtils.newHashMap(2);
        requestProperty.put("Accept-Encoding", "gzip");
        requestProperty.put("Content-Encoding", "gzip");
        requestProperty.put("Content-Type", "application/json");
        return HttpUtils.post(url, json, timeout, requestProperty);
    }

    static String handleResponseText(URLConnection connection, Charset responseCharset) throws IOException {
        try (InputStream inputStream = connection.getInputStream();){
            String encoding = connection.getContentEncoding();
            if ("gzip".equalsIgnoreCase(encoding)) {
                try (GZIPInputStream gzip = new GZIPInputStream(inputStream);){
                    String string = HttpUtils.readResponseText(gzip, responseCharset);
                    return string;
                }
            }
            String string = HttpUtils.readResponseText(inputStream, responseCharset);
            return string;
        }
    }

    private static String readResponseText(InputStream inputStream, Charset responseCharset) throws IOException {
        return StringUtils.readString(inputStream, responseCharset);
    }
}

