/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import xyz.noark.core.exception.HttpAccessException;
import xyz.noark.core.util.CharsetUtils;
import xyz.noark.core.util.HttpUtils;
import xyz.noark.core.util.StringUtils;
import xyz.noark.log.LogHelper;

public class HttpsUtils {
    public static String get(String url) {
        return HttpsUtils.get(url, 3000, Collections.emptyMap());
    }

    public static String get(String url, int timeout) {
        return HttpsUtils.get(url, timeout, Collections.emptyMap());
    }

    public static String get(String url, Map<String, String> requestProperty) {
        return HttpsUtils.get(url, 3000, requestProperty);
    }

    public static String get(String url, int timeout, Map<String, String> requestProperty) {
        LogHelper.logger.info("GET: url={}", new Object[]{url});
        try {
            HttpsURLConnection connection = HttpsUtils.createHttpsUrlConnection(url);
            connection.setRequestMethod("GET");
            connection.setReadTimeout(timeout);
            requestProperty.forEach(connection::setRequestProperty);
            String result = StringUtils.readString(connection.getInputStream());
            LogHelper.logger.info(result);
            return result;
        }
        catch (Exception e) {
            throw new HttpAccessException(e);
        }
    }

    public static String post(String url, String params) {
        return HttpsUtils.post(url, params, 3000, Collections.emptyMap());
    }

    public static String post(String url, String params, int timeout) {
        return HttpsUtils.post(url, params, timeout, Collections.emptyMap());
    }

    public static String post(String url, String params, Map<String, String> requestProperty) {
        return HttpsUtils.post(url, params, 3000, requestProperty);
    }

    public static String post(String url, String params, int timeout, Map<String, String> requestProperty) {
        return HttpsUtils.post(url, params, timeout, requestProperty, CharsetUtils.CHARSET_UTF_8);
    }

    public static String post(String url, String params, int timeout, Map<String, String> requestProperty, Charset responseCharset) {
        LogHelper.logger.info("POST: url={}, param={}", new Object[]{url, params});
        try {
            HttpsURLConnection connection = HttpsUtils.createHttpsUrlConnection(url);
            connection.setRequestMethod("POST");
            connection.setReadTimeout(timeout);
            requestProperty.forEach(connection::setRequestProperty);
            HttpUtils.buildPostParamsAndSend(connection, params, requestProperty);
            return HttpUtils.handleResponseText(connection, responseCharset);
        }
        catch (Exception e) {
            throw new HttpAccessException(e);
        }
    }

    private static HttpsURLConnection createHttpsUrlConnection(String url) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        HttpsURLConnection connection = (HttpsURLConnection)new URL(url).openConnection();
        connection.setSSLSocketFactory(HttpsUtils.initSslSocketFactory(new DefaultTrustManager()));
        connection.setHostnameVerifier(new DefaultHostnameVerifier());
        return connection;
    }

    private static SSLSocketFactory initSslSocketFactory(TrustManager trustManager) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        return sc.getSocketFactory();
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class DefaultHostnameVerifier
    implements HostnameVerifier {
        private DefaultHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

