/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import xyz.noark.core.util.StringUtils;

public class IdCodeUtils {
    private static final char[] CHARS = new char[]{'2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final int CODE_CHARS_LENGTH = CHARS.length;
    private static final int[] NUMS = new int[91];

    public static String toCode(long id) {
        char[] buf = new char[13];
        int index = buf.length - 1;
        while (id >= (long)CODE_CHARS_LENGTH) {
            buf[index--] = CHARS[(int)(id % (long)CODE_CHARS_LENGTH)];
            id >>>= 5;
        }
        buf[index] = CHARS[(int)id];
        return new String(buf, index, buf.length - index);
    }

    public static long toLong(String code) {
        if (StringUtils.isEmpty(code)) {
            return 0L;
        }
        long id = NUMS[code.charAt(0)];
        for (int i = 1; i < code.length(); ++i) {
            id <<= 5;
            id |= (long)NUMS[code.charAt(i)];
        }
        return id;
    }

    static {
        for (int i = 0; i < CHARS.length; ++i) {
            IdCodeUtils.NUMS[IdCodeUtils.CHARS[i]] = i;
        }
    }
}

