/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import xyz.noark.core.util.StringUtils;

public class IpUtils {
    private static final int IP_LOOP_NUM = 3;
    private static final String LOCAL_IP = "127.0.0.1";
    private static long A_BEGIN = IpUtils.ipToLong("10.0.0.0");
    private static long A_END = IpUtils.ipToLong("10.255.255.255");
    private static long B_BEGIN = IpUtils.ipToLong("172.16.0.0");
    private static long B_END = IpUtils.ipToLong("172.31.255.255");
    private static long C_BEGIN = IpUtils.ipToLong("192.168.0.0");
    private static long C_END = IpUtils.ipToLong("192.168.255.255");

    public static long ipToLong(String ipAddress) {
        String[] array = StringUtils.split(ipAddress, ".");
        long result = 0L;
        for (int i = 3; i >= 0; --i) {
            result |= Long.parseLong(array[3 - i]) << i * 8;
        }
        return result;
    }

    public static boolean isInnerIp(String ipAddress) {
        long ipNum = IpUtils.ipToLong(ipAddress);
        return IpUtils.isInner(ipNum, A_BEGIN, A_END) || IpUtils.isInner(ipNum, B_BEGIN, B_END) || IpUtils.isInner(ipNum, C_BEGIN, C_END) || LOCAL_IP.equals(ipAddress);
    }

    private static boolean isInner(long ipNum, long begin, long end) {
        return ipNum >= begin && ipNum <= end;
    }

    public static String getIp(SocketAddress address) {
        return ((InetSocketAddress)address).getAddress().getHostAddress();
    }
}

