/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import xyz.noark.core.lang.Point;
import xyz.noark.core.util.MapUtils;

public class MathUtils {
    public static final double ONE = 1.0;
    public static final double HUNDRED = 100.0;
    public static final double THOUSAND = 1000.0;
    public static final double TEN_THOUSAND = 10000.0;
    public static final double MILLION = 1000000.0;

    public static int addExact(int x, int y) {
        try {
            return Math.addExact(x, y);
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
    }

    public static long addExact(long x, long y) {
        try {
            return Math.addExact(x, y);
        }
        catch (ArithmeticException e) {
            return Long.MAX_VALUE;
        }
    }

    public static int multiplyExact(int x, int y) {
        try {
            return Math.multiplyExact(x, y);
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
    }

    public static long multiplyExact(long x, long y) {
        try {
            return Math.multiplyExact(x, y);
        }
        catch (ArithmeticException e) {
            return Long.MAX_VALUE;
        }
    }

    public static double distance(int x1, int y1, int x2, int y2) {
        double x = Math.abs(x1 - x2);
        double y = Math.abs(y1 - y2);
        return Math.sqrt(x * x + y * y);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        double x = Math.abs(x1 - x2);
        double y = Math.abs(y1 - y2);
        return Math.sqrt(x * x + y * y);
    }

    public static double distance(Point p1, Point p2) {
        return MathUtils.distance(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static boolean adjacent(int x1, int y1, int x2, int y2) {
        return Math.abs(x1 - x2) <= 1 && Math.abs(y1 - y2) <= 1;
    }

    public static boolean adjacent(Point p1, Point p2) {
        return MathUtils.adjacent(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static int floorInt(double a) {
        return (int)Math.floor(a);
    }

    public static long floorLong(double a) {
        return (long)Math.floor(a);
    }

    public static int ceilInt(double a) {
        return (int)Math.ceil(a);
    }

    public static long ceilLong(double a) {
        return (long)Math.ceil(a);
    }

    public static int roundInt(double a) {
        return (int)Math.round(a);
    }

    public static long roundLong(double a) {
        return Math.round(a);
    }

    public static float formatScale(float value, int newScale) {
        return MathUtils.formatScale(value, newScale, RoundingMode.HALF_UP);
    }

    public static float formatScale(float value, int newScale, RoundingMode mode) {
        return BigDecimal.valueOf(value).setScale(newScale, mode).floatValue();
    }

    public static double formatScale(double value, int newScale) {
        return MathUtils.formatScale(value, newScale, RoundingMode.HALF_UP);
    }

    public static double formatScale(double value, int newScale, RoundingMode mode) {
        return BigDecimal.valueOf(value).setScale(newScale, mode).doubleValue();
    }

    public static <T> Map<T, Long> plunder(Map<T, Long> resources, long max, Map<T, Integer> ratio) {
        HashMap result = MapUtils.newHashMap(ratio.size());
        if (max <= 0L) {
            return result;
        }
        MathUtils.plunder(resources, result, max, ratio);
        return result;
    }

    private static <T> void plunder(Map<T, Long> resources, Map<T, Long> result, long max, Map<T, Integer> ratio) {
        int ratioSum = 0;
        for (Map.Entry<T, Integer> e : ratio.entrySet()) {
            Long value = resources.get(e.getKey());
            if (value == null || value <= 0L || e.getValue() <= 0) continue;
            ratioSum += e.getValue().intValue();
        }
        long plunderNum = 0L;
        for (Map.Entry<T, Long> e : resources.entrySet()) {
            long ratioValue;
            Integer r;
            if (e.getValue() <= 0L || (r = ratio.get(e.getKey())) == null || (ratioValue = MathUtils.floorLong((double)max * (r.doubleValue() / (double)ratioSum))) <= 0L) continue;
            long totalValue = e.getValue();
            if (totalValue >= ratioValue) {
                plunderNum += ratioValue;
                e.setValue(totalValue - ratioValue);
                MapUtils.addValue(result, e.getKey(), ratioValue);
                continue;
            }
            plunderNum += totalValue;
            e.setValue(0L);
            MapUtils.addValue(result, e.getKey(), totalValue);
        }
        if (plunderNum <= 0L) {
            MathUtils.fixPlunderDeficiency(resources, result, max, ratio);
        } else if (max > plunderNum) {
            MathUtils.plunder(resources, result, max - plunderNum, ratio);
        }
    }

    private static <T> void fixPlunderDeficiency(Map<T, Long> resources, Map<T, Long> result, long max, Map<T, Integer> ratio) {
        for (Map.Entry<T, Long> e : resources.entrySet()) {
            Integer r;
            if (e.getValue() <= 0L || (r = ratio.get(e.getKey())) == null || r <= 0) continue;
            long totalValue = e.getValue();
            if (totalValue >= max) {
                e.setValue(totalValue - max);
                MapUtils.addValue(result, e.getKey(), max);
                break;
            }
            e.setValue(0L);
            MapUtils.addValue(result, e.getKey(), totalValue);
            max -= totalValue;
        }
    }

    public static double longToDouble(long value, double ratio) {
        return (double)value / ratio;
    }

    public static double permillage(long value) {
        return MathUtils.longToDouble(value, 1000.0);
    }

    public static double percentage(long value) {
        return MathUtils.longToDouble(value, 100.0);
    }
}

