/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import xyz.noark.core.exception.NoPublicMethodException;

public class MethodUtils {
    public static Object invoke(Object target, Method method, Object ... args) {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("\u53cd\u5c04\u8c03\u7528\u65b9\u5f0f\u65f6\u51fa\u73b0\u4e86\u5f02\u5e38\u60c5\u51b5...", e);
        }
    }

    public static List<Method> getAllMethod(Class<?> klass) {
        HashSet<Method> result = new HashSet<Method>();
        for (Class<?> target = klass; target != Object.class; target = target.getSuperclass()) {
            for (Method method : target.getDeclaredMethods()) {
                result.add(method);
            }
        }
        return new ArrayList<Method>(result);
    }

    public static Method getMethod(Class<?> klass, String name, Class<?> ... parameterTypes) {
        try {
            return klass.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new NoPublicMethodException(e.getMessage());
        }
    }

    public static boolean existSetMethod(Class<?> klass) {
        for (Class<?> target = klass; target != Object.class; target = target.getSuperclass()) {
            for (Method method : target.getDeclaredMethods()) {
                if (!method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }
}

