/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.ToIntFunction;

public class RandomUtils {
    private RandomUtils() {
    }

    public static boolean nextBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    public static int nextInt(int bound) {
        return ThreadLocalRandom.current().nextInt(bound);
    }

    public static int nextInt(int origin, int bound) {
        return ThreadLocalRandom.current().nextInt(origin, bound);
    }

    public static long nextLong(long bound) {
        return ThreadLocalRandom.current().nextLong(bound);
    }

    public static long nextLong(long origin, long bound) {
        return ThreadLocalRandom.current().nextLong(origin, bound);
    }

    public static boolean isSuccess(float rate) {
        return ThreadLocalRandom.current().nextFloat() < rate;
    }

    public static boolean isSuccess(double rate) {
        return ThreadLocalRandom.current().nextDouble() < rate;
    }

    public static boolean isSuccessByPercentage(long rate) {
        return RandomUtils.isSuccess((double)rate / 100.0);
    }

    public static boolean isSuccessByPermillage(long rate) {
        return RandomUtils.isSuccess((double)rate / 1000.0);
    }

    public static <T> T randomList(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(RandomUtils.nextInt(list.size()));
    }

    public static <T> List<T> randomList(List<T> source, int num) {
        if (source == null || num < 1) {
            return Collections.emptyList();
        }
        if (source.size() <= num) {
            ArrayList<T> result = new ArrayList<T>(source);
            Collections.shuffle(result);
            return result;
        }
        Object[] rs = source.toArray();
        ArrayList<Object> result = new ArrayList<Object>(num);
        for (int i = 0; i < num; ++i) {
            int index = RandomUtils.nextInt(rs.length - i);
            result.add(rs[index]);
            rs[index] = rs[rs.length - 1 - i];
        }
        return result;
    }

    public static <K> K randomByWeight(Map<K, Integer> data) {
        int sum = data.values().stream().reduce(0, Integer::sum);
        if (sum <= 0) {
            return RandomUtils.randomList(new ArrayList<K>(data.keySet()));
        }
        int random = RandomUtils.nextInt(sum);
        int step = 0;
        for (Map.Entry<K, Integer> e : data.entrySet()) {
            if ((step += e.getValue().intValue()) <= random) continue;
            return e.getKey();
        }
        throw new RuntimeException("randomByWeight\u7684\u5b9e\u73b0\u6709Bug\uff1a" + random);
    }

    public static <K> List<K> randomByWeight(Map<K, Integer> data, int num) {
        int sum = data.values().stream().reduce(0, Integer::sum);
        if (sum <= 0) {
            return RandomUtils.randomList(new ArrayList<K>(data.keySet()), num);
        }
        ArrayList<K> result = new ArrayList<K>(num);
        block0: for (int i = 1; i <= num; ++i) {
            int random = RandomUtils.nextInt(sum);
            int step = 0;
            for (Map.Entry<K, Integer> e : data.entrySet()) {
                if ((step += e.getValue().intValue()) <= random) continue;
                result.add(e.getKey());
                continue block0;
            }
        }
        return result;
    }

    public static <T> T randomByWeight(List<T> data, ToIntFunction<? super T> weightFunction) {
        int sum = data.stream().mapToInt(weightFunction).reduce(0, Integer::sum);
        if (sum <= 0) {
            return RandomUtils.randomList(data);
        }
        int random = RandomUtils.nextInt(sum);
        int step = 0;
        for (T e : data) {
            if ((step += weightFunction.applyAsInt(e)) <= random) continue;
            return e;
        }
        throw new RuntimeException("randomByWeight\u7684\u5b9e\u73b0\u6709Bug\uff1a" + random);
    }

    public static <T> List<T> randomByWeight(List<T> data, ToIntFunction<? super T> weightFunction, int num) {
        if (num <= 0) {
            return Collections.emptyList();
        }
        int sum = data.stream().mapToInt(weightFunction).reduce(0, Integer::sum);
        if (sum <= 0) {
            return RandomUtils.randomList(data, num);
        }
        ArrayList<T> result = new ArrayList<T>(num);
        block0: for (int i = 1; i <= num; ++i) {
            int random = RandomUtils.nextInt(sum);
            int step = 0;
            for (T e : data) {
                if ((step += weightFunction.applyAsInt(e)) <= random) continue;
                result.add(e);
                continue block0;
            }
        }
        return result;
    }
}

