/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.csv;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import xyz.noark.core.annotation.tpl.TplAttr;
import xyz.noark.core.annotation.tpl.TplFile;
import xyz.noark.core.converter.ConvertManager;
import xyz.noark.core.converter.Converter;
import xyz.noark.core.exception.ConvertException;
import xyz.noark.core.exception.TplAttrRequiredException;
import xyz.noark.core.exception.TplConfigurationException;
import xyz.noark.core.exception.UnrealizedException;
import xyz.noark.core.util.CharsetUtils;
import xyz.noark.core.util.ClassUtils;
import xyz.noark.core.util.FieldUtils;
import xyz.noark.core.util.MethodUtils;
import xyz.noark.core.util.StringUtils;
import xyz.noark.csv.CsvReader;
import xyz.noark.log.LogHelper;

public class Csv {
    private final ConvertManager convertManager = ConvertManager.getInstance();
    private final char separator;

    public Csv() {
        this(',');
    }

    public Csv(char separator) {
        this.separator = separator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> loadAll(String templatePath, Class<T> klass) {
        TplFile file = klass.getAnnotation(TplFile.class);
        if (file == null) {
            throw new TplConfigurationException("\u8fd9\u4e0d\u662fCSV\u683c\u5f0f\u7684\u914d\u7f6e\u6587\u4ef6\u7c7b:" + klass.getName());
        }
        if (MethodUtils.existSetMethod(klass)) {
            LogHelper.logger.warn("\u6a21\u677f\u7c7b\u6b63\u5e38\u4e3a\u53ea\u8bfb\u6a21\u5f0f\uff0c\u4e0d\u5e94\u8be5\u5b58\u5728Set\u65b9\u6cd5\u5662\uff0cclass={}", new Object[]{klass.getName()});
        }
        try (CsvReader reader = new CsvReader(this.separator, Files.newBufferedReader(Paths.get(templatePath, file.value()), CharsetUtils.CHARSET_UTF_8));){
            Map<String, Integer> titles = reader.getHeaders();
            ArrayList result = new ArrayList();
            reader.getDatas().forEach(v -> result.add(this.analysisLine(klass, file.value(), titles, (String[])v)));
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            throw new TplConfigurationException("CSV\u683c\u5f0f\u7684\u914d\u7f6e\u6587\u4ef6\u7c7b:" + klass.getName(), (Exception)e);
        }
    }

    private <T> T analysisLine(Class<T> klass, String tplFileName, Map<String, Integer> titles, String[] values) {
        Object result = ClassUtils.newInstance(klass);
        for (Field field : FieldUtils.getAllField(klass)) {
            TplAttr[] array = (TplAttr[])field.getAnnotationsByType(TplAttr.class);
            if (array == null || array.length == 0) continue;
            if (array.length == 1) {
                String value;
                TplAttr attr = array[0];
                TplAttr[] index = titles.get(attr.name());
                if (index == null) {
                    if (!attr.required()) continue;
                    throw new TplAttrRequiredException(klass, field, attr);
                }
                if (index.intValue() > values.length - 1 || StringUtils.isEmpty((String)(value = values[index.intValue()]))) continue;
                Converter<?> converter = this.getConverter(field);
                try {
                    FieldUtils.writeField((Object)result, (Field)field, (Object)converter.convert(field, value));
                    continue;
                }
                catch (Exception e) {
                    throw new ConvertException(tplFileName + " >> " + field.getName() + " >> " + value + "-->" + converter.buildErrorMsg(), e);
                }
            }
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>(array.length + 1);
            for (TplAttr attr : array) {
                String value;
                Integer index = titles.get(attr.name());
                if (index == null) {
                    if (!attr.required()) continue;
                    throw new TplAttrRequiredException(klass, field, attr);
                }
                if (index > values.length - 1 || StringUtils.isEmpty((String)(value = values[index]))) continue;
                data.put(attr.name(), value);
            }
            Converter<?> converter = this.getConverter(field);
            try {
                FieldUtils.writeField((Object)result, (Field)field, (Object)converter.convert(field, data));
            }
            catch (Exception e) {
                throw new ConvertException(tplFileName + " >> " + field.getName() + " >> " + data + "-->" + converter.buildErrorMsg(), e);
            }
        }
        return (T)result;
    }

    private Converter<?> getConverter(Field field) {
        Converter result = this.convertManager.getConverter(field.getType());
        if (result == null) {
            throw new UnrealizedException("CSV\u914d\u7f6e\u89e3\u6790\u65f6\uff0c\u53d1\u73b0\u672a\u5b9e\u73b0\u7684\u7c7b\u578b. field=(" + field.getType().getName() + ")" + field.getName());
        }
        return result;
    }
}

