/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

class CsvReader
implements AutoCloseable {
    private static final int LF = 10;
    private static final int CR = 13;
    private static final int QUOTE = 34;
    private final BufferedReader reader;
    private final int separator;
    private final StringBuilder sbing;
    private final Map<String, Integer> headers;
    private int cur;
    private boolean processed = true;

    public CsvReader(char separator, BufferedReader reader) throws IOException {
        this.reader = reader;
        this.separator = separator;
        this.sbing = new StringBuilder(256);
        this.headers = new HashMap<String, Integer>();
        this.readHeaders();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public Map<String, Integer> getHeaders() {
        return this.headers;
    }

    public Stream<String[]> getDatas() throws IOException {
        Stream.Builder<String[]> result = Stream.builder();
        while (!this.isFileEnd()) {
            String[] line = this.readLine();
            if (line.length <= 0) continue;
            result.add(line);
        }
        return result.build();
    }

    private void readHeaders() throws IOException {
        String[] values = this.readLine();
        for (int i = 0; i < values.length; ++i) {
            this.headers.put(values[i], i);
        }
    }

    private String[] readLine() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        while (true) {
            this.readInt();
            if (this.cur == 10 || this.isFileEnd()) break;
            result.add(this.readString());
        }
        this.processed = true;
        return result.toArray(new String[0]);
    }

    private String readString() throws IOException {
        this.sbing.setLength(0);
        boolean flag = false;
        while (true) {
            this.readInt();
            if (!flag && this.cur == 34) {
                this.processed = true;
                flag = true;
            }
            if (flag) {
                this.readInt();
                if (this.cur == 34) {
                    this.processed = true;
                    this.readInt();
                    if (this.cur == this.separator) {
                        this.processed = true;
                        break;
                    }
                    if (this.cur == 10) {
                        break;
                    }
                }
            } else {
                if (this.cur == this.separator) {
                    this.processed = true;
                    break;
                }
                if (this.cur == 10) break;
            }
            this.processed = true;
            this.sbing.append((char)this.cur);
        }
        if (this.sbing.length() > 0 && this.sbing.charAt(this.sbing.length() - 1) == '\r') {
            this.sbing.deleteCharAt(this.sbing.length() - 1);
        }
        return this.sbing.toString();
    }

    private void readInt() throws IOException {
        if (this.processed) {
            this.processed = false;
            this.cur = this.reader.read();
        }
    }

    private boolean isFileEnd() {
        return this.cur == -1;
    }
}

