/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.game;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import xyz.noark.core.env.EnvConfigHolder;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.lang.UnicodeInputStream;
import xyz.noark.core.util.BooleanUtils;
import xyz.noark.core.util.MapUtils;
import xyz.noark.core.util.StringUtils;
import xyz.noark.game.Noark;
import xyz.noark.game.config.NacosConfigCentre;
import xyz.noark.game.crypto.StringEncryptor;
import xyz.noark.log.LogHelper;

class NoarkPropertiesLoader {
    private static final String BOOTSTRAP_PREFIX = "bootstrap";
    private static final String APPLICATION_PREFIX = "application";
    private static final String PROPERTIES_SUFFIX = ".properties";
    private final ClassLoader loader = this.getClass().getClassLoader();
    private final HashMap<String, String> properties = MapUtils.newHashMap((int)128);

    NoarkPropertiesLoader() {
        this.properties.put("noark.version", Noark.getVersion());
    }

    public void loadingArgs(String ... args) {
        for (String arg : args) {
            int index;
            if (!arg.startsWith("--") || (index = arg.indexOf(61, 2)) <= 1) continue;
            String optionName = arg.substring(2, index);
            String optionValue = arg.substring(index + 1);
            if (StringUtils.isBlank((String)optionName) || StringUtils.isBlank((String)optionValue)) {
                throw new IllegalArgumentException("Invalid argument syntax: " + arg);
            }
            this.properties.put(optionName, optionValue);
        }
    }

    void loadingProperties() {
        String profile = this.properties.getOrDefault("noark.profiles.active", "test");
        this.properties.putAll(this.loadingFile(BOOTSTRAP_PREFIX, profile));
        this.properties.putAll(this.loadingFile(APPLICATION_PREFIX, profile));
        this.loadingConfigAfter(this.properties);
    }

    private void loadingConfigAfter(HashMap<String, String> result) {
        StringEncryptor encryptor = new StringEncryptor(result);
        for (Map.Entry<String, String> e : result.entrySet()) {
            e.setValue(encryptor.decrypt(e.getValue()));
        }
        for (Map.Entry<String, String> e : result.entrySet()) {
            e.setValue(EnvConfigHolder.fillExpression((String)e.getValue(), result, (boolean)true));
        }
    }

    private HashMap<String, String> loadingFile(String filename, String profile) {
        HashMap config = MapUtils.newHashMap((int)128);
        this.loadingFile(filename + PROPERTIES_SUFFIX, config);
        if (StringUtils.isNotEmpty((String)profile)) {
            this.loadingFile(filename + "-" + profile + PROPERTIES_SUFFIX, config);
        }
        return config;
    }

    private void loadingFile(String filename, Map<String, String> config) {
        try (InputStream in = this.loader.getResourceAsStream(filename);){
            if (in == null) {
                return;
            }
            try (UnicodeInputStream uis = new UnicodeInputStream(in, "UTF-8");
                 InputStreamReader isr = new InputStreamReader((InputStream)uis, uis.getEncoding());){
                Properties props = new Properties();
                props.load(isr);
                for (Map.Entry<Object, Object> e : props.entrySet()) {
                    String value;
                    String key = e.getKey().toString().trim();
                    if (this.properties.containsKey(key) || config.put(key, value = e.getValue().toString().trim()) == null) continue;
                    System.err.println("\u8986\u76d6\u914d\u7f6e >>" + key + "=" + value);
                }
            }
        }
        catch (IOException e) {
            throw new ServerBootstrapException("\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38... filename=" + filename);
        }
    }

    public void loadingConfigCentre() {
        if (BooleanUtils.toBoolean((String)this.properties.get("noark.nacos.enabled"))) {
            this.loadConfigCentre(this.properties);
            this.loadingConfigAfter(this.properties);
        }
    }

    private void loadConfigCentre(HashMap<String, String> result) {
        String sid = result.get("server.id");
        if (StringUtils.isEmpty((String)sid)) {
            throw new ServerBootstrapException("application.properties\u6587\u4ef6\u4e2d\u5fc5\u9700\u8981\u914d\u7f6e\u533a\u670dID,server.id=XXX");
        }
        LogHelper.logger.info("\u6b63\u5728\u542f\u52a8\u914d\u7f6e\u4e2d\u5fc3\u6a21\u5f0f sid={}", new Object[]{sid});
        NacosConfigCentre cc = new NacosConfigCentre(result);
        cc.loadConfig(sid).forEach(result::putIfAbsent);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

