/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.game.bootstrap;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import xyz.noark.core.ModularManager;
import xyz.noark.core.env.EnvConfigHolder;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.ioc.NoarkIoc;
import xyz.noark.core.network.PacketCodec;
import xyz.noark.core.network.PacketCodecHolder;
import xyz.noark.core.thread.NamedThreadFactory;
import xyz.noark.core.util.BooleanUtils;
import xyz.noark.core.util.FileUtils;
import xyz.noark.core.util.StringUtils;
import xyz.noark.core.util.SystemUtils;
import xyz.noark.game.bootstrap.ServerBootstrap;
import xyz.noark.game.bootstrap.ShutdownHook;
import xyz.noark.log.LogHelper;
import xyz.noark.log.LogManager;

public abstract class AbstractServerBootstrap
implements ServerBootstrap {
    protected NoarkIoc ioc;
    protected ModularManager modularManager;
    private String pidFileName;

    public AbstractServerBootstrap() {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook(this));
    }

    protected abstract String getServerName();

    @Override
    public void start() {
        LogHelper.logger.info("starting {} service...", new Object[]{this.getServerName()});
        long startTime = System.nanoTime();
        try {
            this.ioc = new NoarkIoc(this.getClass().getPackage().getName());
            this.modularManager = (ModularManager)this.ioc.get(ModularManager.class);
            this.onBeginStart();
            this.onStart();
            float interval = (float)(System.nanoTime() - startTime) / 1000000.0f;
            LogHelper.logger.info("{} is running, interval={} ms", new Object[]{this.getServerName(), Float.valueOf(interval)});
            System.out.println(this.getServerName() + " is running, interval=" + interval + " ms");
            if (this.showBanner()) {
                FileUtils.loadFileText((String)this.bannerFileName()).ifPresent(this::printBanner);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LogHelper.logger.error("failed to starting service:{}, exception={}", new Object[]{this.getServerName(), e});
            System.exit(1);
        }
    }

    protected void onBeginStart() {
        PacketCodecHolder.setPacketCodec((PacketCodec)this.getPacketCodec());
        if (this.shutdownSignalEnabled()) {
            LogHelper.logger.warn("\u5df2\u542f\u7528\u56de\u8f66\u505c\u673a\u529f\u80fd");
            ThreadPoolExecutor singleThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1), (ThreadFactory)new NamedThreadFactory("\u5b89\u5168\u505c\u670d\uff1a\u6d4b\u8bd5\u542f\u7528"));
            singleThreadPool.execute(() -> {
                try {
                    int read = System.in.read();
                    LogHelper.logger.debug("\u6536\u5230\u4fe1\u606f\uff1a{}", new Object[]{read});
                }
                catch (Exception e) {
                    LogHelper.logger.error("{}", new Object[]{e});
                }
                System.exit(0);
            });
        }
        this.pidFileName = EnvConfigHolder.getString((String)"pid.file");
        this.createPidFile();
    }

    protected boolean shutdownSignalEnabled() {
        String signal = EnvConfigHolder.getString((String)"shutdown.signal.enabled");
        boolean flag = StringUtils.isEmpty((String)signal) ? SystemUtils.IS_OS_WINDOWS : BooleanUtils.toBoolean((String)signal);
        return flag;
    }

    protected void createPidFile() {
        if (StringUtils.isNotEmpty((String)this.pidFileName)) {
            try {
                File pidFile = new File(this.pidFileName);
                if (!FileUtils.createNewFile((File)pidFile)) {
                    String fileName = this.pidFileName;
                    this.pidFileName = null;
                    throw new ServerBootstrapException("PID\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u5982\u679c\u5f02\u5e38\u505c\u670d\uff0c\u8bf7\u624b\u52a8\u5220\u9664PID\u6587\u4ef6 >> " + fileName);
                }
                LogHelper.logger.debug("PID\u6587\u4ef6\u521b\u5efa\u6210\u529f.");
                try (FileWriter fileWriter = new FileWriter(pidFile, false);){
                    fileWriter.write(SystemUtils.getPidStr());
                    fileWriter.flush();
                }
            }
            catch (IOException e) {
                throw new ServerBootstrapException("PID\u6587\u4ef6\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u4e00\u4e0b\u6743\u9650\u662f\u5426\u6b63\u5e38 >> " + this.pidFileName, (Exception)e);
            }
        }
    }

    protected abstract PacketCodec getPacketCodec();

    protected abstract void onStart();

    @Override
    public void stop() {
        LogHelper.logger.info("stopping service: {}", new Object[]{this.getServerName()});
        try {
            LogHelper.logger.info("goodbye {}", new Object[]{this.getServerName()});
            System.out.println("goodbye " + this.getServerName());
            this.onStop();
        }
        catch (Exception e) {
            LogHelper.logger.error("failed to stopping service:{}", new Object[]{this.getServerName(), e});
        }
        finally {
            if (this.ioc != null) {
                this.ioc.destroy();
            }
            LogManager.shutdown();
            this.deletePidFile();
        }
    }

    protected void deletePidFile() {
        File pidFile;
        if (StringUtils.isNotEmpty((String)this.pidFileName) && (pidFile = new File(this.pidFileName)).exists() && !pidFile.delete()) {
            LogHelper.logger.warn("PID\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u786e\u8ba4\u5e76\u5220\u9664.");
        }
    }

    protected abstract void onStop();

    protected boolean showBanner() {
        return true;
    }

    protected String bannerFileName() {
        return "noark.banner";
    }

    protected void printBanner(String text) {
        LogHelper.logger.info(EnvConfigHolder.fillExpression((String)text));
    }
}

