/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.game.bootstrap;

import java.util.Optional;
import javax.annotation.PostConstruct;
import xyz.noark.core.Modular;
import xyz.noark.core.annotation.orm.DataCheckAndInit;
import xyz.noark.core.network.PacketCodec;
import xyz.noark.game.bootstrap.AbstractServerBootstrap;
import xyz.noark.game.template.ReloadManager;
import xyz.noark.network.NettyServer;
import xyz.noark.network.codec.json.SimpleJsonCodec;

public abstract class BaseServerBootstrap
extends AbstractServerBootstrap {
    protected NettyServer nettyServer;
    protected Modular dataModular;
    protected Modular eventModular;
    protected Modular httpModular;
    protected Modular threadModular;

    @Override
    protected void onStart() {
        this.initThreadModular();
        this.initDataModular();
        ((ReloadManager)this.ioc.get(ReloadManager.class)).reload(true);
        this.ioc.invokeCustomAnnotationMethod(PostConstruct.class);
        this.initEventModular();
        this.initHttpModular();
        this.initNetworkModular();
    }

    protected void initNetworkModular() {
        this.nettyServer = (NettyServer)this.ioc.get(NettyServer.class);
        this.nettyServer.startup();
    }

    protected void initHttpModular() {
        Optional modular = this.modularManager.getModular("HttpModular");
        modular.ifPresent(Modular::init);
        this.httpModular = modular.orElse(null);
    }

    protected void initEventModular() {
        Optional modular = this.modularManager.getModular("EventModular");
        modular.ifPresent(Modular::init);
        this.eventModular = modular.orElse(null);
    }

    protected void initDataModular() {
        Optional modular = this.modularManager.getModular("DataModular");
        modular.ifPresent(dataModular -> {
            this.dataModular = dataModular;
            dataModular.init();
            this.ioc.invokeCustomAnnotationMethod(DataCheckAndInit.class);
        });
    }

    protected void initThreadModular() {
        Optional modular = this.modularManager.getModular("ThreadModular");
        modular.ifPresent(Modular::init);
        this.threadModular = modular.orElse(null);
    }

    @Override
    protected PacketCodec getPacketCodec() {
        return new SimpleJsonCodec();
    }

    @Override
    protected void onStop() {
        Optional.ofNullable(this.nettyServer).ifPresent(NettyServer::shutdown);
        this.onStopHttpModular();
        this.onStopEventModular();
        this.onStopThreadModular();
        this.onStopDataModular();
    }

    protected void onStopHttpModular() {
        Optional.ofNullable(this.httpModular).ifPresent(Modular::destroy);
    }

    protected void onStopEventModular() {
        Optional.ofNullable(this.eventModular).ifPresent(Modular::destroy);
    }

    protected void onStopThreadModular() {
        Optional.ofNullable(this.threadModular).ifPresent(Modular::destroy);
    }

    protected void onStopDataModular() {
        Optional.ofNullable(this.dataModular).ifPresent(Modular::destroy);
    }
}

