/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.game.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.util.HttpUtils;
import xyz.noark.core.util.MapUtils;
import xyz.noark.core.util.RandomUtils;
import xyz.noark.core.util.StringUtils;
import xyz.noark.game.config.AbstractConfigCentre;

public class NacosConfigCentre
extends AbstractConfigCentre {
    private static final String DEFAULT_GROUP = "DEFAULT_GROUP";
    private final List<String> serverAddrList;
    private final String username;
    private final String password;
    private final String tenant;

    public NacosConfigCentre(HashMap<String, String> basicConfig) {
        super(basicConfig);
        String addr = basicConfig.getOrDefault("noark.nacos.server-addr", "127.0.0.1:8848");
        String[] array = StringUtils.split((String)addr, (String)";");
        ArrayList<String> serverAddr = new ArrayList<String>(array.length);
        for (String s : array) {
            if (!StringUtils.isNotBlank((String)s)) continue;
            serverAddr.add(s);
        }
        this.serverAddrList = serverAddr;
        this.tenant = basicConfig.getOrDefault("noark.nacos.namespaces", "public");
        this.username = basicConfig.get("noark.nacos.username");
        this.password = basicConfig.get("noark.nacos.password");
    }

    @Override
    public Map<String, String> loadConfig(String sid) {
        HashMap<String, String> result = new HashMap<String, String>(32);
        result.putAll(this.nacosLoadConfig("application.properties"));
        result.putAll(this.nacosLoadConfig(StringUtils.join((String[])new String[]{"application-", sid, ".properties"})));
        return result;
    }

    private Map<String, String> nacosLoadConfig(String dataId) {
        String serverAddr = (String)RandomUtils.randomList(this.serverAddrList);
        String url = StringUtils.isNotEmpty((String)this.username) ? StringUtils.join((String[])new String[]{"http://", serverAddr, "/nacos/v1/cs/configs?dataId=", dataId, "&group=", DEFAULT_GROUP, "&tenant=", this.tenant, "&username=", this.username, "&password=", this.password}) : StringUtils.join((String[])new String[]{"http://", serverAddr, "/nacos/v1/cs/configs?dataId=", dataId, "&group=", DEFAULT_GROUP, "&tenant=", this.tenant});
        try {
            return this.toMap(HttpUtils.get((String)url));
        }
        catch (IOException e) {
            throw new ServerBootstrapException("\u52a0\u8f7dNacos\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e\u65f6\u53d1\u751f\u4e86\u5f02\u5e38\u60c5\u51b5", (Exception)e);
        }
    }

    public Map<String, String> toMap(String result) {
        String[] allLine = StringUtils.split((String)result, (String)"\n");
        HashMap configMap = MapUtils.newHashMap((int)allLine.length);
        for (String line : allLine) {
            String lineValue;
            if (line == null || (lineValue = line.trim()).startsWith("#")) continue;
            String[] array = StringUtils.split((String)lineValue, (String)"=", (int)2);
            if (array.length == 1) {
                configMap.put(array[0], "");
                continue;
            }
            if (array.length != 2) continue;
            configMap.put(array[0], array[1]);
        }
        return configMap;
    }
}

