/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.game.dfa;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import xyz.noark.game.dfa.DfaNode;
import xyz.noark.game.dfa.DfaResult;

abstract class AbstractDfaScanner {
    protected static final char SBC_CHAR_START = '\uff01';
    protected static final char SBC_CHAR_END = '\uff5e';
    protected static final char SBC_SPACE = '\u3000';
    protected static final char DBC_SPACE = ' ';
    protected static final int CONVERT_STEP = 65248;
    protected static final char SHOW_SIGN = '*';
    private final Set<Integer> separatesSymbols;
    private final Map<Integer, DfaNode> nodes;

    public AbstractDfaScanner() {
        this(new HashSet<Integer>(), new HashMap<Integer, DfaNode>());
    }

    public AbstractDfaScanner(Set<Integer> separatesSymbols, Map<Integer, DfaNode> nodes) {
        this.separatesSymbols = separatesSymbols;
        this.nodes = nodes;
    }

    protected void initSeparatesSymbol(String symbols) {
        int len = symbols.length();
        for (int i = 0; i < len; ++i) {
            this.separatesSymbols.add(this.charConvert(symbols.charAt(i)));
        }
    }

    protected DfaNode addSensitiveWords(String word) {
        int first = this.charConvert(word.charAt(0));
        DfaNode fnode = this.nodes.computeIfAbsent(first, key -> new DfaNode(first, word.length() == 1));
        if (word.length() == 1) {
            fnode.setLast(true);
        } else {
            int len = word.length();
            int lastIndex = len - 1;
            for (int i = 1; i < len; ++i) {
                fnode = fnode.addIfAbsent(this.charConvert(word.charAt(i)), i == lastIndex);
            }
        }
        return fnode;
    }

    private int qj2bj(char src) {
        if (src >= '\uff01' && src <= '\uff5e') {
            return src - 65248;
        }
        if (src == '\u3000') {
            return 32;
        }
        return src;
    }

    protected int charConvert(char src) {
        int r = this.qj2bj(src);
        return r >= 65 && r <= 90 ? r + 32 : r;
    }

    public boolean contains(String text) {
        return this.analysis(text, 1, false).isExist();
    }

    public String replace(String text) {
        return this.analysis(text, 0, true).getText();
    }

    public Optional<String> find(String text) {
        return this.analysis(text, 1, false).getWords().stream().findFirst();
    }

    public List<String> findAll(String text) {
        return this.analysis(text, 0, false).getWords();
    }

    private DfaResult analysis(String text, int limit, boolean replace) {
        LocalDateTime now = LocalDateTime.now();
        DfaResult result = new DfaResult();
        boolean flag = false;
        char[] array = text.toCharArray();
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            int k;
            int cur = this.charConvert(array[i]);
            DfaNode node = this.nodes.get(cur);
            if (node == null) continue;
            boolean mark = false;
            int markIndex = -1;
            if (node.isLast() && node.isValid(now)) {
                mark = true;
                markIndex = i;
            }
            int backups = cur;
            DfaNode backupsNode = node;
            for (k = i + 1; k < length; ++k) {
                int temp = this.charConvert(array[k]);
                node = backupsNode.querySub(temp);
                if (node == null) {
                    if (temp != backups && !this.separatesSymbols.contains(temp)) break;
                    continue;
                }
                backupsNode = node;
                backups = temp;
                markIndex = k;
                if (!node.isLast() || !node.isValid(now)) continue;
                mark = true;
                if (limit == 1) break;
            }
            if (!mark) continue;
            flag = true;
            result.addSensitiveWord(new String(array, i, markIndex - i + 1));
            if (replace) {
                for (k = i; k <= markIndex; ++k) {
                    array[k] = 42;
                }
            }
            i = markIndex;
            if (limit > 0 && result.getWords().size() >= limit) break;
        }
        result.setExist(flag);
        result.setText(flag ? new String(array) : text);
        return result;
    }
}

