/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.game.dfa;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;
import xyz.noark.core.lang.ValidTime;

class DfaNode {
    private int value;
    private List<DfaNode> subNodes;
    private boolean last;
    private ValidTime validTime;

    DfaNode(int value, boolean last) {
        this.value = value;
        this.last = last;
    }

    DfaNode addIfAbsent(int value, boolean last) {
        if (this.subNodes != null) {
            for (DfaNode subNode : this.subNodes) {
                if (subNode.value != value) continue;
                if (!subNode.last && last) {
                    subNode.last = true;
                }
                return subNode;
            }
        }
        return this.addSubNode(new DfaNode(value, last));
    }

    private DfaNode addSubNode(DfaNode subNode) {
        if (this.subNodes == null) {
            this.subNodes = new LinkedList<DfaNode>();
        }
        this.subNodes.add(subNode);
        return subNode;
    }

    DfaNode querySub(int value) {
        if (this.subNodes == null) {
            return null;
        }
        for (DfaNode subNode : this.subNodes) {
            if (subNode.value != value) continue;
            return subNode;
        }
        return null;
    }

    boolean isLast() {
        return this.last;
    }

    void setLast(boolean last) {
        this.last = last;
    }

    void setValidTime(ValidTime validTime) {
        this.validTime = validTime;
    }

    boolean isValid(LocalDateTime now) {
        return this.validTime == null || this.validTime.isValid(now);
    }
}

