/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.game.event;

import java.util.List;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.Service;
import xyz.noark.core.event.DelayEvent;
import xyz.noark.core.event.Event;
import xyz.noark.core.event.EventManager;
import xyz.noark.core.event.FixedTimeEvent;
import xyz.noark.core.exception.HackerException;
import xyz.noark.core.ioc.manager.EventMethodManager;
import xyz.noark.core.ioc.manager.ScheduledMethodManager;
import xyz.noark.core.ioc.wrap.method.EventMethodWrapper;
import xyz.noark.core.ioc.wrap.method.ScheduledMethodWrapper;
import xyz.noark.core.thread.ThreadDispatcher;
import xyz.noark.game.event.DelayEventThread;
import xyz.noark.game.event.FixedTimeEventWrapper;
import xyz.noark.game.event.ScheduledEvent;
import xyz.noark.log.LogHelper;

@Service
public class DefaultEventManager
implements EventManager {
    private static final EventMethodManager EVENT_MANAGER = EventMethodManager.getInstance();
    private static final ScheduledMethodManager SCHEDULED_MANAGER = ScheduledMethodManager.getInstance();
    @Autowired
    private static ThreadDispatcher threadDispatcher;
    private final DelayEventThread handler = new DelayEventThread(this);

    public void init() {
        this.handler.start();
        this.initScheduled();
    }

    private void initScheduled() {
        for (ScheduledMethodWrapper sch : SCHEDULED_MANAGER.getHandlers()) {
            ScheduledEvent event = new ScheduledEvent();
            event.setId(sch.getId());
            event.setEndTime(sch.nextExecutionTime());
            this.publish(event);
        }
    }

    public void destroy() {
        this.handler.shutdown();
    }

    public void publish(Event event) {
        this.notifyListeners(event);
    }

    public void publish(DelayEvent event) {
        if (event.getEndTime() == null) {
            throw new HackerException("\u672a\u914d\u7f6e\u5ef6\u8fdf\u4e8b\u4ef6\u7684\u7ed3\u675f\u65f6\u95f4. class=" + event.getClass().getName());
        }
        this.handler.addDelayEvent(event);
    }

    public boolean remove(DelayEvent event) {
        return this.handler.remove(event);
    }

    public void publish(FixedTimeEvent event) {
        if (event.getTrigger() == null) {
            throw new HackerException("\u672a\u914d\u7f6e\u5b9a\u65f6\u4efb\u52a1\u7684\u89e6\u53d1\u65f6\u95f4. class=" + event.getClass().getName());
        }
        this.resetEndTimeAndPublish(new FixedTimeEventWrapper(event));
    }

    private void resetEndTimeAndPublish(FixedTimeEventWrapper event) {
        event.setEndTime(event.getSource().getTrigger().doNext());
        this.publish(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListeners(Event event) {
        List handlers = EVENT_MANAGER.getEventMethodWrappers(event.getClass());
        if (handlers.isEmpty()) {
            EventMethodManager eventMethodManager = EVENT_MANAGER;
            synchronized (eventMethodManager) {
                handlers = EVENT_MANAGER.rebuildEventHandler(event.getClass());
            }
            if (handlers.isEmpty()) {
                LogHelper.logger.warn("No subscription event. class={}", new Object[]{event.getClass()});
                return;
            }
        }
        for (EventMethodWrapper handler : handlers) {
            try {
                if (handler.isAsync()) {
                    threadDispatcher.dispatchEvent(handler, event);
                    continue;
                }
                handler.invoke(new Object[]{event});
            }
            catch (Exception e) {
                LogHelper.logger.warn("handle event exception. {}", new Object[]{e});
            }
        }
    }

    void notifyScheduledHandler(ScheduledEvent event) {
        ScheduledMethodWrapper method = SCHEDULED_MANAGER.getHandler(Long.valueOf(event.getId()));
        threadDispatcher.dispatchScheduled(method);
        event.setEndTime(method.nextExecutionTime());
        this.publish(event);
    }

    void notifyFixedTimeEventHandler(FixedTimeEventWrapper event) {
        this.notifyListeners(event.getSource());
        this.resetEndTimeAndPublish(event);
    }

    void notifyListeners(FixedTimeEvent event) {
        List handlers = EVENT_MANAGER.getEventMethodWrappers(event.getClass());
        if (handlers.isEmpty()) {
            LogHelper.logger.warn("No subscription event. class={}", new Object[]{event.getClass()});
            return;
        }
        for (EventMethodWrapper handler : handlers) {
            try {
                threadDispatcher.dispatchFixedTimeEvent(handler, event);
            }
            catch (Exception e) {
                LogHelper.logger.warn("handle event exception. {}", new Object[]{e});
            }
        }
    }
}

